(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    965214,      21990]
NotebookOptionsPosition[    957892,      21875]
NotebookOutlinePosition[    958330,      21892]
CellTagsIndexPosition[    958287,      21889]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Extract platelet thicknesses and radii from SAXS data", "Title",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138361009327*^9}, {3.889001234807024*^9, 
  3.889001235941153*^9}},ExpressionUUID->"9752d005-1219-465f-8e60-\
2082113917f8"],

Cell[TextData[{
 "This notebook contains the functions to calculate platelet thickness \
distributions from SAXS patterns.  Analysis of individual samples should be \
performed with the notebook ",
 StyleBox["Sample playground.nb",
  FontSlant->"Italic"],
 ".",
 "\nThe current notebook contains functions for the following steps:"
}], "Text",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138477031891*^9}, {3.8601400466828275`*^9, 
  3.8601400869865527`*^9}},ExpressionUUID->"49403409-d150-494f-b081-\
91ce56c28d83"],

Cell["\<\
Process (average, subtract background, merge), export and plot SAXS patterns\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 
  3.860138515531695*^9}},ExpressionUUID->"c5bb304f-f48f-4254-b437-\
103257a6e918"],

Cell["\<\
Data fitting (calculate (polydisperse) form factor, fit slopes (note that \
intensity fit has been remove for the full form factor incl platelet radius))\
\
\>", "Item",
 CellChangeTimes->{{3.854421073333592*^9, 3.854421085540827*^9}, {
  3.860138334587551*^9, 3.860138516926824*^9}, {3.8601386478729086`*^9, 
  3.860138664129044*^9}, {3.889498683509451*^9, 
  3.8894987072659907`*^9}},ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-\
39e8721130f8"],

Cell[CellGroupData[{

Cell["Import data & setup functions", "Subsubsection",
 CellChangeTimes->{{3.854421073333592*^9, 
  3.854421085540827*^9}},ExpressionUUID->"e214e2f0-1723-47e3-b5e6-\
cc97977345b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{3.891917782999442*^9, 3.902388336342721*^9},
 CellLabel->
  "In[1280]:=",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", 
       "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataPath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
       "\"\<2023-07_new_data/Laura-E-series\>\""}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"dataPath", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
        "\"\<2023-07_new_data/Lisette\>\""}], "}"}], "]"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"dataPath", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<C:/Users/s168562/OneDrive - TU \
Eindhoven/PhD/4_Colloidal_interactions/ESRF/Analysis\>\"", ",", 
        "\"\<2022-08_new_data/Graphene_data_capillaries_ave\>\""}], "}"}], 
      "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dataPath", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fileNames", "=", 
     RowBox[{"FileNames", "[", 
      RowBox[{
      "RegularExpression", "[", "\"\<\\\\w+eiger2_\\\\d+_ave.h5\>\"", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "fileNames", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.843291109702825*^9, 3.843291129724827*^9}, {
   3.843291167128108*^9, 3.843291185479764*^9}, {3.843291219598308*^9, 
   3.843291222024798*^9}, {3.843291264579451*^9, 3.8432912853783493`*^9}, 
   3.843291319173628*^9, {3.8432913509667788`*^9, 3.843291375972494*^9}, {
   3.843291451400524*^9, 3.843291477387067*^9}, {3.8432915074978447`*^9, 
   3.843291534313446*^9}, {3.843292849473691*^9, 3.843292942812584*^9}, {
   3.8432931554440536`*^9, 3.843293227171956*^9}, {3.843293396905971*^9, 
   3.8432934076677513`*^9}, {3.843293598815793*^9, 3.8432936066087017`*^9}, {
   3.84329364169765*^9, 3.843293676946286*^9}, {3.8432937236680613`*^9, 
   3.843293772333598*^9}, {3.843294707626026*^9, 3.843294724210083*^9}, 
   3.843294770372671*^9, {3.8432948815026712`*^9, 3.8432948844789762`*^9}, {
   3.843295139951911*^9, 3.843295151390843*^9}, {3.843296147653944*^9, 
   3.843296185726388*^9}, {3.843296554609067*^9, 3.843296592633421*^9}, {
   3.843296636066904*^9, 3.843296639883025*^9}, {3.8432966844608583`*^9, 
   3.843296707229643*^9}, {3.843296858083069*^9, 3.843296863457725*^9}, {
   3.843297628887661*^9, 3.8432976613287487`*^9}, {3.8432987537158613`*^9, 
   3.843298773059194*^9}, {3.843298823885009*^9, 3.843298834244919*^9}, {
   3.843299789697318*^9, 3.843299804010457*^9}, {3.852781031022092*^9, 
   3.8527810772744493`*^9}, {3.852781158568071*^9, 3.852781201094832*^9}, {
   3.8527812588052597`*^9, 3.852781283480824*^9}, {3.852781419697466*^9, 
   3.852781430649639*^9}, {3.852781469335927*^9, 3.852781497438036*^9}, {
   3.852781543616589*^9, 3.852781633868348*^9}, {3.8527816651702337`*^9, 
   3.852781748919075*^9}, {3.852781791308778*^9, 3.852781813234481*^9}, {
   3.8527818729040623`*^9, 3.852781874767733*^9}, {3.852782031664762*^9, 
   3.852782067804142*^9}, {3.852782890656323*^9, 3.852782892951396*^9}, 
   3.852784938827908*^9, 3.852785110185223*^9, 3.852785990266891*^9, {
   3.8527861525799932`*^9, 3.852786159462245*^9}, {3.8527862029249353`*^9, 
   3.852786226420244*^9}, {3.853381378758465*^9, 3.853381378945614*^9}, 
   3.853496150649447*^9, {3.8538177863332767`*^9, 3.8538177873549957`*^9}, 
   3.853818176511339*^9, {3.853833034447925*^9, 3.853833034613881*^9}, {
   3.854098398903439*^9, 3.8540983999200363`*^9}, {3.860137189571525*^9, 
   3.860137217401352*^9}, {3.885971180865988*^9, 3.885971188443076*^9}, {
   3.888309497309559*^9, 3.888309616445239*^9}, {3.8894988210904903`*^9, 
   3.889498848750657*^9}, {3.8895036360318656`*^9, 3.889503646388072*^9}, {
   3.8895036902148943`*^9, 3.8895037221118603`*^9}, {3.889503752320318*^9, 
   3.889503789653923*^9}, {3.8895039643492126`*^9, 3.889504039947297*^9}, {
   3.891917778214884*^9, 3.8919177861047926`*^9}, {3.9023883385279427`*^9, 
   3.902388346868284*^9}, {3.903593980932661*^9, 3.903593986453227*^9}, {
   3.9040134706123905`*^9, 3.9040134748645406`*^9}, {3.905228447002757*^9, 
   3.905228456666749*^9}, {3.905851427989444*^9, 3.9058514317194977`*^9}, {
   3.9060126639111533`*^9, 3.906012667210704*^9}, {3.907908382062703*^9, 
   3.9079083881433363`*^9}, {3.913800222603778*^9, 3.913800225759153*^9}, {
   3.915525831078533*^9, 3.915525836157426*^9}, {3.9186314898065653`*^9, 
   3.9186315098104525`*^9}, {3.918727067744544*^9, 3.918727071310844*^9}},
 CellLabel->
  "In[1281]:=",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2023-07_\
new_data\\\\Laura-E-series\"\>"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.8926269141604004`*^9, 3.9020316096006217`*^9, 
   3.9020343883823447`*^9, 3.9021976227155824`*^9, 3.9023108504241867`*^9, 
   3.902388353662442*^9, 3.9034204506799946`*^9, 3.9035939945873938`*^9, {
   3.9040134559429665`*^9, 3.9040134819929066`*^9}, 3.9040343362221656`*^9, 
   3.904110237476866*^9, 3.9041154147019634`*^9, 3.904116021485797*^9, 
   3.9041163515507517`*^9, 3.904628481939262*^9, 3.904816370801213*^9, 
   3.90481641697658*^9, 3.9058512971122837`*^9, 3.9071451017489185`*^9, 
   3.90790839203039*^9, 3.9079087975926094`*^9, 3.913800233779008*^9, 
   3.9152686533863134`*^9, 3.9155258405163684`*^9, 3.9156930546297655`*^9, 
   3.917498571244748*^9, 3.9175130044166512`*^9, 3.917943602723419*^9, 
   3.9185605603419847`*^9, 3.918727074689911*^9},
 CellLabel->
  "Out[1281]=",ExpressionUUID->"3509a962-286c-4324-a276-3a3c68471146"],

Cell[BoxData["1069"], "Output",
 CellChangeTimes->{
  3.8895036121748714`*^9, 3.889503647604984*^9, 3.8895037225313816`*^9, 
   3.889503796811266*^9, 3.8895038798579345`*^9, {3.889504042983837*^9, 
   3.8895040528657637`*^9}, 3.889668463822626*^9, 3.890202604224517*^9, 
   3.890976837791486*^9, 3.8914129610421104`*^9, 3.891490100998623*^9, {
   3.8919177898508825`*^9, 3.891917801264139*^9}, 3.8919181780843434`*^9, 
   3.892609275047814*^9, 3.8926269141604004`*^9, 3.9020316096006217`*^9, 
   3.9020343883823447`*^9, 3.9021976227155824`*^9, 3.9023108504241867`*^9, 
   3.902388353662442*^9, 3.9034204506799946`*^9, 3.9035939945873938`*^9, {
   3.9040134559429665`*^9, 3.9040134819929066`*^9}, 3.9040343362221656`*^9, 
   3.904110237476866*^9, 3.9041154147019634`*^9, 3.904116021485797*^9, 
   3.9041163515507517`*^9, 3.904628481939262*^9, 3.904816370801213*^9, 
   3.90481641697658*^9, 3.9058512971122837`*^9, 3.9071451017489185`*^9, 
   3.90790839203039*^9, 3.9079087975926094`*^9, 3.913800233779008*^9, 
   3.9152686533863134`*^9, 3.9155258405163684`*^9, 3.9156930546297655`*^9, 
   3.917498571244748*^9, 3.9175130044166512`*^9, 3.917943602723419*^9, 
   3.9185605603419847`*^9, 3.918727074854326*^9},
 CellLabel->
  "Out[1284]=",ExpressionUUID->"787b56db-b8a8-4b57-a9eb-eb78b2ff5b7f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Extract", " ", "all", " ", "file", " ", "names"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetSharedVariable", "[", "j", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Monitor", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"titles", "=", 
       RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"title", "=", 
           RowBox[{"StringRiffle", "[", 
            RowBox[{
             RowBox[{"Import", "[", 
              RowBox[{
               RowBox[{"FileNameJoin", "[", 
                RowBox[{"{", 
                 RowBox[{"dataPath", ",", 
                  RowBox[{"fileNames", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/Title\>\"", 
                  ",", "\"\</entry_0000/PyFAI/id02-eiger2-saxs/header/\
SampleDistance\>\""}], "}"}], "}"}]}], "]"}], ",", "\"\<_\>\""}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"title", ",", 
            RowBox[{"fileNames", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "fileNames", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", "j"}], 
     "\[IndentingNewLine]", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.852786431189885*^9, {3.852787104362198*^9, 3.852787107216403*^9}, {
   3.8534692703745604`*^9, 3.853469276630739*^9}, {3.853489232693318*^9, 
   3.853489233219405*^9}, {3.853499517183794*^9, 3.853499520757019*^9}, {
   3.8534995809431887`*^9, 3.853499582335005*^9}, {3.860137268641552*^9, 
   3.860137282028754*^9}, 3.903421248426809*^9},
 CellLabel->
  "In[1285]:=",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sampleFiles", "=", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"titles", ",", 
      RowBox[{"First", "\[Rule]", "Last"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "files", " ", "by", " ", "their", " ", "sample", " ", 
    "name"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "q", " ", "data", " ", "for", 
    " ", "a", " ", "certain", " ", "filename"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scatteringDataFile", "[", "filename_", "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"filename", ",", "\"\</entry_0000/PyFAI/result_ave/q\>\""}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Import", "[", 
        RowBox[{
        "filename", ",", "\"\</entry_0000/PyFAI/result_ave/data\>\""}], "]"}],
        "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "\[Transpose]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Function", " ", "to", " ", "import", " ", "all", " ", "q", " ", "data", 
    " ", "files", " ", "for", " ", "one", " ", "sample"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSample", "[", "samplename_", "]"}], ":=", 
    RowBox[{"scatteringDataFile", "/@", 
     RowBox[{"sampleFiles", "[", "samplename", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
     
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], 
     ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"MeanAround", "/@", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], "}"}], 
        "\[Transpose]"}], "&"}], "@", 
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveraged", "[", "samplename_", "]"}], ":=", 
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Average", " ", "all", " ", "measurements"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleStdev", "[", "samplename_", "]"}], ":=", 
    RowBox[{"StandardDeviation", "[", 
     RowBox[{
      RowBox[{"GatherBy", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"scatteringDataSample", "[", "samplename", "]"}], ",", 
          "1"}], "]"}], ",", "First"}], "]"}], "\[Transpose]"}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Calculate", " ", "standard", " ", "deviation"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"scatteringDataSampleAveragedErrors", "[", "samplename_", "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
       "\[Transpose]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Calculate", " ", "average", " ", "and", " ", "stdev", " ", "in", " ", 
       "one", " ", "go"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Around", "@@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"scatteringDataSampleStdev", "[", "samplename", "]"}], 
            "\[Transpose]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "\[Transpose]"}], 
       ")"}]}]}], "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}]}], "Input",\

 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, 3.8601381527942257`*^9},
 CellLabel->
  "In[1288]:=",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Data processing functions", "Subsection"]], \
"Subsubsection",
 CellChangeTimes->{{3.8601381777337103`*^9, 3.8601382230184765`*^9}, {
  3.8601382660907316`*^9, 
  3.8601382667694025`*^9}},ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-\
969547bc7a05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Function", " ", "to", " ", "subtract", " ", "background"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
     RowBox[{"samplename_", ",", "backgroundname_", ",", "c_"}], "]"}], ":=", 
    
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scatdata", ",", "backdata"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scatdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "samplename", "]"}], 
         "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"backdata", "=", 
        RowBox[{
         RowBox[{"scatteringDataSampleAveraged", "[", "backgroundname", "]"}],
          "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"scatdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "==", 
          RowBox[{"backdata", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Select", "[", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
            "selecting", " ", "only", " ", "positive", " ", "intensities"}], 
            ";", " ", 
            RowBox[{"change", " ", "if", " ", "desired"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"scatdata", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"scatdata", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", 
               RowBox[{"c", " ", 
                RowBox[{"backdata", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], 
            "\[Transpose]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Positive", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "&"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Null"}], "\[IndentingNewLine]", "]"}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "to", " ", "bin", " ", "the", " ", 
     RowBox[{"(", 
      RowBox[{"already", " ", 
       RowBox[{"averaged", "/", "background"}], " ", "subtracted", " ", "if", 
       " ", "desired"}], ")"}], " ", "data"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"binData", "[", 
      RowBox[{"list_", ",", "binning_"}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"Exp", "[", "binnedLogData", "]"}], "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Function", " ", "to", " ", "export", " ", "a", " ", "dataset", " ", 
      "containing", " ", "three", " ", 
      RowBox[{"columns", ":", " ", "q"}]}], ",", " ", 
     RowBox[{"Mean", 
      RowBox[{"(", "I", ")"}], " ", "and", " ", "std", 
      RowBox[{"(", "I", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exportData", "[", "list_", "]"}], " ", ":=", " ", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"exportlist", " ", "=", " ", 
          RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"datamergedbinned", " ", "=", " ", "list"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"TrueQ", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Around"}], "||", 
              RowBox[{
               RowBox[{"Head", "[", 
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
               "Real"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{
             "exportlist", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"datamergedbinned", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Which", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Around"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Value\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"TrueQ", "[", 
                   RowBox[{
                    RowBox[{"Head", "[", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
                    "Real"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"datamergedbinned", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                  "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", 
                  "Null"}], "\[IndentingNewLine]", "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Head", "[", "\[IndentingNewLine]", 
                    RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], 
                    "\[IndentingNewLine]", "]"}], "\[Equal]", "Around"}], ",",
                   "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"datamergedbinned", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", 
                   "\"\<Uncertainty\>\"", "]"}], ",", "\[IndentingNewLine]", 
                  "0", ",", "\[IndentingNewLine]", "0"}], 
                 "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
               "}"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]",
            "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamergedbinned", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "exportlist", "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "extract", " ", "the", " ", "slopes", " ", 
     "from", " ", "the", " ", "pattern"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"slope", "[", 
      RowBox[{
       RowBox[{"list_", "?", "ListQ"}], ",", 
       RowBox[{"binning_", ":", "False"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"logData", "=", 
          RowBox[{"Log", "[", "list", "]"}]}], ",", "\[IndentingNewLine]", 
         "binnedRawLogData", ",", "\[IndentingNewLine]", "binnedLogData", ",",
          "\[IndentingNewLine]", "slopesBinned", ",", "\[IndentingNewLine]", 
         "slopes"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumberQ", "[", "binning", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"binnedRawLogData", "=", 
           RowBox[{"BinListsBy", "[", 
            RowBox[{"logData", ",", 
             RowBox[{"{", 
              RowBox[{"First", ",", 
               RowBox[{"Min", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               RowBox[{"Max", "[", 
                RowBox[{"logData", "[", 
                 RowBox[{"[", 
                  RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
               "binning"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"binnedLogData", "=", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Mean", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "1"}], "]"}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"MeanAround", "/@", 
               RowBox[{"binnedRawLogData", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", ";;", ",", "2"}], "]"}], "]"}]}]}], 
             "\[IndentingNewLine]", "}"}], "\[Transpose]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"slopesBinned", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"binnedLogData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "binnedLogData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopesBinned", "]"}], ";"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"slopes", "=", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"MovingAverage", "[", 
                RowBox[{
                 RowBox[{"logData", "[", 
                  RowBox[{"[", 
                   RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
               "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", 
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}], "/@", 
               RowBox[{"Differences", "[", "logData", "]"}]}]}], "}"}], 
            "\[Transpose]"}]}], ";", " ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{
             "Return", " ", "in", " ", "the", " ", "first", " ", "column", 
              " ", "the", " ", "q"}], "-", 
             RowBox[{"value", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "actually", " ", "the", " ", "exponent", " ", "of", " ", 
                  "the", " ", "natural", " ", "log", " ", "of", " ", "the", 
                  " ", "q"}], "-", "value"}], ",", " ", 
                RowBox[{
                 RowBox[{"hence", " ", "the", " ", "q"}], "-", 
                 RowBox[{"value", " ", "itself"}]}]}], ")"}]}]}], ",", " ", 
            RowBox[{"in", " ", "the", " ", "second", " ", 
             RowBox[{
              RowBox[{"column", " ", "[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", 
                    RowBox[{"q", "+", "1"}], ")"}]}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"I", 
                   RowBox[{"(", "q", ")"}]}], ")"}]}]}], "]"}], "/", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"ln", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "1"}], ")"}]}], "-", 
                RowBox[{"ln", 
                 RowBox[{"(", "q", ")"}]}]}], "]"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
              "effectively", " ", "the", " ", "slope", " ", "in", " ", "each",
                " ", "point"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"Return", "[", "slopes", "]"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BinListsBy", "[", 
     RowBox[{"data_List", ",", " ", "binspecs__List"}], "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fs", ",", " ", "idata", ",", " ", "len", ",", " ", "out", ",", " ", 
        "dims"}], "}"}], ",", " ", 
      RowBox[{
       RowBox[{"len", " ", "=", " ", 
        RowBox[{"Length", "[", "data", "]"}]}], ";", " ", 
       RowBox[{"fs", " ", "=", " ", 
        RowBox[{"{", "binspecs", "}"}]}], ";", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"AllTrue", "[", 
          RowBox[{"fs", ",", " ", 
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"#1", ",", " ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}], " ", "|", " ", 
               RowBox[{"{", 
                RowBox[{"_", ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}], ",", " ", 
                 RowBox[{"_", "?", "NumericQ"}]}], "}"}]}]}], "]"}], " ", 
            "&"}]}], " ", "]"}], ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"len", " ", ">", " ", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"idata", " ", "=", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"f", " ", "/@", " ", "data"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"f", ",", " ", 
                 RowBox[{"fs", "[", 
                  RowBox[{"[", 
                   RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "}"}]}], 
              "]"}]}], ";", " ", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"idata", ",", " ", 
              RowBox[{"Range", "[", "len", "]"}]}], "]"}], ";", " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"BinLists", "[", 
              RowBox[{
               RowBox[{"Transpose", "[", "idata", "]"}], ",", " ", 
               RowBox[{"Sequence", " ", "@@", " ", 
                RowBox[{"Rest", " ", "/@", " ", "fs"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}], ",", " ", 
                 RowBox[{"len", " ", "+", " ", "1"}]}], "}"}]}], "]"}]}], ";",
             " ", 
            RowBox[{"out", " ", "=", " ", 
             RowBox[{"out", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Sequence", " ", "@@", " ", 
                 RowBox[{"ConstantArray", "[", 
                  RowBox[{"All", ",", " ", 
                   RowBox[{"Length", "[", "fs", "]"}]}], "]"}]}], ",", "1", 
                ",", "All", ",", 
                RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", " ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "#1", "]"}], "]"}], " ", "&"}], " ", ",", " ", 
              "out", ",", " ", 
              RowBox[{"{", 
               RowBox[{"Length", "[", "fs", "]"}], "}"}]}], "]"}]}], ",", " ", 
           RowBox[{
            RowBox[{"dims", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Range", " ", "@@", " ", "#1"}], "]"}], " ", "-", 
                 " ", "1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
              RowBox[{"Rest", " ", "/@", " ", "fs"}]}]}], ";", " ", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{
              RowBox[{"{", "}"}], ",", " ", "dims"}], "]"}]}]}], "]"}], ",", 
         " ", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"BinListsBy", "::", "invalidspec"}], ",", " ", "fs"}], 
          "]"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BinListsBy", "::", "invalidspec"}], " ", "=", " ", 
     "\"\<One or more of your binning specifications `1` is incorrect\
\[Ellipsis]\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Sort", "[", 
    RowBox[{"Keys", "[", "sampleFiles", "]"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"Merging", " ", "data", " ", "sets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mergeData", "[", 
     RowBox[{
      RowBox[{"dataset1_", "?", "ListQ"}], ",", 
      RowBox[{"dataset2_", "?", "ListQ"}]}], "]"}], ":=", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data1", "=", 
         RowBox[{"Log", "[", "dataset1", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"data2", "=", 
         RowBox[{"Log", "[", "dataset2", "]"}]}], ",", "\[IndentingNewLine]", 
        "overlapRange", ",", "\[IndentingNewLine]", "overlap1", ",", 
        "\[IndentingNewLine]", "overlap2", ",", "\[IndentingNewLine]", 
        "overlappos", ",", "\[IndentingNewLine]", "scale", ",", 
        "\[IndentingNewLine]", "cutoff", ",", "\[IndentingNewLine]", 
        "cutoffno", ",", "\[IndentingNewLine]", "movingstdev"}], 
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"overlapRange", "=", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Max", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ">", 
            RowBox[{"Min", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Min", "[", 
             RowBox[{"data2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
            RowBox[{"Max", "[", 
             RowBox[{"data1", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Max", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "&&", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], "<", 
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", ","}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{"data1", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Max", "[", 
               RowBox[{"data2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], 
            ","}], "*)"}], "\[IndentingNewLine]", "True", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
          "Return", "[", "\"\<Error, no overlap, wrong order?\>\"", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap1", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data1", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"overlap2", "=", 
        RowBox[{"Select", "[", 
         RowBox[{"data2", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"overlapRange", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"overlappos", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Nearest", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"overlap1", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "\[Rule]", 
            RowBox[{"Range", "[", 
             RowBox[{"Length", "[", "overlap1", "]"}], "]"}]}], ",", 
           RowBox[{"overlap2", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"scale", "=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", "c", "]"}], "/.", 
          RowBox[{
           RowBox[{"FindMinimum", "[", 
            RowBox[{
             RowBox[{"Norm", "[", 
              RowBox[{
               RowBox[{"overlap1", "[", 
                RowBox[{"[", 
                 RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
               RowBox[{"overlap2", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "2"}], "]"}], "]"}], "-", "c"}], "]"}], 
             ",", "c"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"movingstdev", "=", 
        RowBox[{"MovingAverage", "[", 
         RowBox[{
          RowBox[{"MovingMap", "[", 
           RowBox[{"StandardDeviation", ",", 
            RowBox[{
             RowBox[{"overlap1", "[", 
              RowBox[{"[", 
               RowBox[{"overlappos", ",", "2"}], "]"}], "]"}], "-", " ", 
             RowBox[{"overlap2", "[", 
              RowBox[{"[", 
               RowBox[{";;", ",", "2"}], "]"}], "]"}], "+", 
             RowBox[{"Log", "[", "scale", "]"}]}], ",", "10"}], "]"}], ",", 
          "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cutoffno", "=", 
        RowBox[{"First", "[", 
         RowBox[{"First", "[", 
          RowBox[{"Position", "[", 
           RowBox[{"movingstdev", ",", 
            RowBox[{"_", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#", ">", "0.01"}], "&"}], ")"}]}]}], "]"}], "]"}], 
         "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"was", " ", "0.1"}], ",", " ", 
         RowBox[{
         "but", " ", "gave", " ", "error", " ", "in", " ", "case", " ", "of", 
          " ", "already", " ", 
          RowBox[{"(", "almost", ")"}], " ", "overlapping", " ", "curves"}]}],
         " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"cutoff", "=", 
        RowBox[{"Exp", "[", 
         RowBox[{"overlap2", "[", 
          RowBox[{"[", 
           RowBox[{"cutoffno", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"Sort", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{"dataset1", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "cutoff"}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"dataset2", ".", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "scale"}], "}"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.852781860752527*^9, 3.852781861400449*^9}, {
   3.852782427495048*^9, 3.852782432845196*^9}, {3.852782490522458*^9, 
   3.8527825233607388`*^9}, 3.852782757511119*^9, {3.8527828983994617`*^9, 
   3.852782923717813*^9}, {3.852783954273013*^9, 3.852783958577043*^9}, {
   3.852784217988599*^9, 3.852784232189209*^9}, {3.852784588124271*^9, 
   3.852784630667053*^9}, 3.8527849493876867`*^9, 3.852786296410307*^9, {
   3.852786445171461*^9, 3.8527864639719877`*^9}, 3.852786739567677*^9, {
   3.852787449131702*^9, 3.852787450514557*^9}, {3.853381975213027*^9, 
   3.853381976205628*^9}, {3.853382404274076*^9, 3.85338240456852*^9}, {
   3.85340333020494*^9, 3.853403408623046*^9}, {3.85340345847932*^9, 
   3.853403507151403*^9}, {3.853409529667601*^9, 3.8534095895008907`*^9}, {
   3.853409682647615*^9, 3.853409684334144*^9}, {3.853410131707053*^9, 
   3.85341017818784*^9}, {3.8538181053955297`*^9, 3.853818151693227*^9}, {
   3.8538238300771923`*^9, 3.853823831444284*^9}, {3.8544235682712183`*^9, 
   3.854423596844871*^9}, {3.8601372879871793`*^9, 3.860137300912186*^9}, {
   3.8601373341336937`*^9, 3.860137513416378*^9}, {3.8601377878238845`*^9, 
   3.860137825471859*^9}, 3.8601381170176554`*^9, {3.8601381527942257`*^9, 
   3.8601381554698157`*^9}, 3.860139314345042*^9, {3.8601396136069946`*^9, 
   3.860139637809037*^9}, {3.860140274802857*^9, 3.8601402881469436`*^9}, {
   3.8601403266498127`*^9, 3.860140345820403*^9}, {3.860140410589032*^9, 
   3.860140446255523*^9}, {3.8601404885987186`*^9, 3.8601405253716545`*^9}, {
   3.8601405888823967`*^9, 3.8601406208542633`*^9}, {3.860140651384527*^9, 
   3.86014076017659*^9}, {3.8601408369383373`*^9, 3.8601408546914597`*^9}, {
   3.8601412665787563`*^9, 3.860141297881263*^9}, 3.8629073718138065`*^9, {
   3.8636846731243887`*^9, 3.863684721178178*^9}, {3.8636849961195316`*^9, 
   3.8636850169326954`*^9}, {3.863685081135563*^9, 3.8636851178496304`*^9}, {
   3.863685275732274*^9, 3.863685280648721*^9}},
 CellLabel->
  "In[1294]:=",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E10_10.0001\"\>", ",", "\<\"E10_1.5\"\>", 
   ",", "\<\"E10_30.9849\"\>", ",", "\<\"E1_10.0001\"\>", 
   ",", "\<\"E11_10.0001\"\>", ",", "\<\"E11_1.5\"\>", 
   ",", "\<\"E11_30.9849\"\>", ",", "\<\"E1_1.5\"\>", 
   ",", "\<\"E12_10.0001\"\>", ",", "\<\"E12_1.5\"\>", 
   ",", "\<\"E12_30.9849\"\>", ",", "\<\"E1_30.9849\"\>", 
   ",", "\<\"E13_10.0001\"\>", ",", "\<\"E13_1.5\"\>", 
   ",", "\<\"E13_30.9849\"\>", ",", "\<\"E14_10.0001\"\>", 
   ",", "\<\"E14_1.5\"\>", ",", "\<\"E14_30.9849\"\>", 
   ",", "\<\"E15_10.0001\"\>", ",", "\<\"E15_1.5\"\>", 
   ",", "\<\"E15_30.9849\"\>", ",", "\<\"E16_10.0001\"\>", 
   ",", "\<\"E16_1.5\"\>", ",", "\<\"E16_30.9849\"\>", 
   ",", "\<\"E17_10.0001\"\>", ",", "\<\"E17_1.5\"\>", 
   ",", "\<\"E17_30.9849\"\>", ",", "\<\"E18_10.0001\"\>", 
   ",", "\<\"E18_1.5\"\>", ",", "\<\"E18_30.9849\"\>", 
   ",", "\<\"E19_10.0001\"\>", ",", "\<\"E19_1.5\"\>", 
   ",", "\<\"E19_30.9849\"\>", ",", "\<\"E20_10.0001\"\>", 
   ",", "\<\"E20_1.5\"\>", ",", "\<\"E20_30.9849\"\>", 
   ",", "\<\"E2_10.0001\"\>", ",", "\<\"E21_10.0001\"\>", 
   ",", "\<\"E21_1.5\"\>", ",", "\<\"E21_30.9849\"\>", ",", "\<\"E2_1.5\"\>", 
   ",", "\<\"E22_10.0001\"\>", ",", "\<\"E22_1.5\"\>", 
   ",", "\<\"E22_30.9849\"\>", ",", "\<\"E2_30.9849\"\>", 
   ",", "\<\"E23_10.0001\"\>", ",", "\<\"E23_1.5\"\>", 
   ",", "\<\"E23_30.9849\"\>", ",", "\<\"E24_10.0001\"\>", 
   ",", "\<\"E24_1.5\"\>", ",", "\<\"E24_30.9849\"\>", 
   ",", "\<\"E25_10.0001\"\>", ",", "\<\"E25_1.5\"\>", 
   ",", "\<\"E25_30.9849\"\>", ",", "\<\"E26_10.0001\"\>", 
   ",", "\<\"E26_1.5\"\>", ",", "\<\"E26_30.9849\"\>", 
   ",", "\<\"E27_10.0001\"\>", ",", "\<\"E27_1.5\"\>", 
   ",", "\<\"E27_30.9849\"\>", ",", "\<\"E28_10.0001\"\>", 
   ",", "\<\"E28_1.5\"\>", ",", "\<\"E28_30.9849\"\>", 
   ",", "\<\"E29_10.0001\"\>", ",", "\<\"E29_1.5\"\>", 
   ",", "\<\"E29_30.9849\"\>", ",", "\<\"E30_10.0001\"\>", 
   ",", "\<\"E30_1.5\"\>", ",", "\<\"E30_30.9849\"\>", 
   ",", "\<\"E3_10.0001\"\>", ",", "\<\"E31_10.0001\"\>", 
   ",", "\<\"E31_1.5\"\>", ",", "\<\"E31_30.9849\"\>", ",", "\<\"E3_1.5\"\>", 
   ",", "\<\"E32_10.0001\"\>", ",", "\<\"E32_1.5\"\>", 
   ",", "\<\"E3_30.9849\"\>", ",", "\<\"E33_10.0001\"\>", 
   ",", "\<\"E33_1.5\"\>", ",", "\<\"E33_30.9849\"\>", ",", "\<\"E4_1.5\"\>", 
   ",", "\<\"E4_2_10.0001\"\>", ",", "\<\"E4_2_1.5\"\>", 
   ",", "\<\"E4_2_30.9849\"\>", ",", "\<\"E4_30.9849\"\>", 
   ",", "\<\"E5_10.0001\"\>", ",", "\<\"E5_1.5\"\>", 
   ",", "\<\"E5_30.9849\"\>", ",", "\<\"E6_10.0001\"\>", 
   ",", "\<\"E6_1.5\"\>", ",", "\<\"E6_30.9849\"\>", 
   ",", "\<\"E68_10.0001\"\>", ",", "\<\"E68_1.5\"\>", 
   ",", "\<\"E68_30.9849\"\>", ",", "\<\"E69_10.0001\"\>", 
   ",", "\<\"E69_1.5\"\>", ",", "\<\"E69_30.9849\"\>", 
   ",", "\<\"E70_10.0001\"\>", ",", "\<\"E70_1.5\"\>", 
   ",", "\<\"E70_30.9849\"\>", ",", "\<\"E7_10.0001\"\>", 
   ",", "\<\"E71_10.0001\"\>", ",", "\<\"E71_1.5\"\>", 
   ",", "\<\"E71_30.9849\"\>", ",", "\<\"E7_1.5\"\>", 
   ",", "\<\"E72_10.0001\"\>", ",", "\<\"E72_1.5\"\>", 
   ",", "\<\"E72_30.9849\"\>", ",", "\<\"E7_30.9849\"\>", 
   ",", "\<\"E8_10.0001\"\>", ",", "\<\"E8_1.5\"\>", 
   ",", "\<\"E8_30.9849\"\>", ",", "\<\"E9_10.0001\"\>", 
   ",", "\<\"E9_1.5\"\>", ",", "\<\"E9_30.9849\"\>", 
   ",", "\<\"MilliQ_10.0001\"\>", ",", "\<\"MilliQ_1.5\"\>", 
   ",", "\<\"MilliQ_30.9849\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.843291116410307*^9, 3.843291130190617*^9}, {
   3.8432911719097652`*^9, 3.843291185978409*^9}, 3.843291220560841*^9, {
   3.8432912704296637`*^9, 3.84329127392964*^9}, 3.843291320135066*^9, {
   3.8432913518879747`*^9, 3.8432913767025137`*^9}, {3.84329145300187*^9, 
   3.843291477899846*^9}, {3.843291512572294*^9, 3.843291534673026*^9}, 
   3.8432928114247313`*^9, 3.843292945133399*^9, {3.843293186383741*^9, 
   3.843293193473956*^9}, 3.843293608109157*^9, 3.843293645515916*^9, {
   3.843293716052813*^9, 3.843293730759082*^9}, {3.843293761080804*^9, 
   3.843293772865118*^9}, 3.8432938713954144`*^9, {3.84329471860441*^9, 
   3.8432947251573477`*^9}, 3.843294771162959*^9, 3.843294885917644*^9, 
   3.843295151895554*^9, 3.8432956501750383`*^9, 3.843296152599977*^9, {
   3.843296189871492*^9, 3.843296191243095*^9}, 3.84329659605822*^9, 
   3.843296864247712*^9, 3.843297654343287*^9, 3.843297684687933*^9, 
   3.843298780405675*^9, 3.8432988461417847`*^9, 3.843299816472809*^9, 
   3.852779404882422*^9, {3.852782926379023*^9, 3.852782939958962*^9}, 
   3.852783082585239*^9, 3.85278423842143*^9, 3.852784635998056*^9, 
   3.852784774684959*^9, 3.85278495816325*^9, 3.852785644257989*^9, 
   3.852786584046872*^9, 3.852787231457491*^9, 3.8527874512893887`*^9, 
   3.8528624946437807`*^9, 3.8533813666181393`*^9, 3.853381473051558*^9, 
   3.853382002859495*^9, {3.853382366117324*^9, 3.8533824068816853`*^9}, 
   3.853382447973559*^9, 3.853402237496472*^9, {3.8534035050061913`*^9, 
   3.853403520153386*^9}, {3.853409576568863*^9, 3.853409590687502*^9}, 
   3.853409686569212*^9, 3.853410179540357*^9, 3.85346909235686*^9, {
   3.853496221708645*^9, 3.853496230454815*^9}, 3.8534962722710114`*^9, 
   3.8534995714970713`*^9, 3.8534996217654676`*^9, {3.8534998537977457`*^9, 
   3.853499861198127*^9}, 3.853817842905547*^9, 3.8538182330499973`*^9, 
   3.853823854615374*^9, 3.853824682278778*^9, 3.8538248698359203`*^9, 
   3.8538330740724907`*^9, 3.853836452527369*^9, 3.853838538520102*^9, 
   3.854072553798176*^9, 3.854091674337735*^9, 3.854098459639974*^9, 
   3.8544207575313673`*^9, {3.854423578230679*^9, 3.854423602648951*^9}, 
   3.8601380332758555`*^9, 3.8601397073699045`*^9, 3.8601408681378775`*^9, 
   3.860141165553254*^9, 3.8617630814145107`*^9, 3.8617632495409374`*^9, 
   3.86194321925034*^9, 3.861950293500869*^9, 3.862109428120537*^9, 
   3.862204577976136*^9, 3.8859712433884926`*^9, 3.8859717023665004`*^9, 
   3.885973538318736*^9, 3.8871822213001337`*^9, 3.888309647401424*^9, 
   3.888309685383727*^9, 3.8883100772164288`*^9, 3.889001634921618*^9, 
   3.889060229645113*^9, 3.889064545330427*^9, 3.88908010527439*^9, 
   3.88908177519516*^9, 3.889082725590596*^9, 3.8890843099944553`*^9, 
   3.889498714652341*^9, 3.889499954222128*^9, 3.8895040850259047`*^9, 
   3.88966850980521*^9, 3.890202669873102*^9, 3.89097689186923*^9, 
   3.8914131817881813`*^9, 3.8914901650050025`*^9, 3.8919178772682314`*^9, 
   3.891918256701417*^9, 3.8926093273920903`*^9, 3.892626965833712*^9, 
   3.902034976330225*^9, 3.9021976646180515`*^9, 3.9023109317620115`*^9, 
   3.903420470169649*^9, 3.904013505318366*^9, 3.9040343603475456`*^9, 
   3.9041102586408815`*^9, 3.9041154307658567`*^9, 3.904116044177828*^9, 
   3.9041163772241936`*^9, 3.904184035433017*^9, 3.9046285193679733`*^9, 
   3.9058513203852787`*^9, 3.906016931953811*^9, 3.907145134293648*^9, 
   3.907908632553444*^9, 3.9079088498452835`*^9, 3.9137863853344994`*^9, 
   3.913800251641613*^9, 3.915268674662794*^9, 3.915526042000633*^9, 
   3.9156931061027875`*^9, 3.917498610108088*^9, 3.917513050233398*^9, 
   3.9179436760773754`*^9, 3.9185606133782396`*^9, 3.918727098657565*^9},
 CellLabel->
  "Out[1300]=",ExpressionUUID->"692fa780-1d82-4946-824a-438fc97d74df"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data fitting commands", "Subsection",
 CellChangeTimes->{{3.853833173909893*^9, 3.85383317510979*^9}, {
  3.854423364858252*^9, 
  3.854423369840681*^9}},ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-\
8094510e4a4e"],

Cell["\<\
importing (or calculating -- which is very slow --, then saving) a table with \
all scattering patterns for a range of q, l, and r\
\>", "Text",
 CellChangeTimes->{{3.889001751397065*^9, 3.8890017945493183`*^9}, {
  3.8894989004771748`*^9, 
  3.8894989080000873`*^9}},ExpressionUUID->"1226fcdb-2e55-460d-933b-\
f363aeb6389f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"qmin", "=", 
    RowBox[{"-", "3"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qmax", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qstep", "=", "0.02"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlist", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"qmin", ",", "qmax", ",", "qstep"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlistslope", "=", 
    RowBox[{"Exp", "[", 
     RowBox[{"MovingAverage", "[", 
      RowBox[{
       RowBox[{"Log", "[", "qlist", "]"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  " ", 
  RowBox[{"(*", 
   RowBox[{"slope", "-", 
    RowBox[{
    "fitting", " ", "is", " ", "done", " ", "using", " ", "log", " ", 
     "scale"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmin", "=", 
    RowBox[{"-", "1"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengthmax", "=", "3"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lengthstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lengths", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"lengthmin", ",", "lengthmax", ",", "lengthstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmin", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radiusmax", "=", "4"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"log", " ", "scale", " ", 
    RowBox[{"10", "^", "x"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"radiusstep", "=", "0.02"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"radii", "=", 
    RowBox[{"10", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"radiusmin", ",", "radiusmax", ",", "radiusstep"}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "lengths", "]"}], "*", 
   RowBox[{"Length", "[", "radii", "]"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "of", " ", "combinations", " ", "of", " ", "L", " ", "and", 
    " ", "R"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "a", " ", "form", " ", "factor", " ", "for", " ", "disk", 
    " ", "with", " ", "radius", " ", "L", " ", "and", " ", "length", " ", "R",
     " ", 
    RowBox[{"(", 
     RowBox[{"Pedersen", " ", "1997"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"P11", "[", 
     RowBox[{"q_", ",", "R_", ",", "L_"}], "]"}], ":=", 
    RowBox[{"Quiet", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"BesselJ", "[", 
              RowBox[{"1", ",", 
               RowBox[{"q", " ", "R", " ", 
                RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "]"}]}], 
            RowBox[{"q", " ", "R", " ", 
             RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]], " ", 
           FractionBox[
            RowBox[{"Sin", "[", 
             FractionBox[
              RowBox[{"q", " ", "L", " ", 
               RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"], "]"}], 
            FractionBox[
             RowBox[{"q", " ", "L", " ", 
              RowBox[{"Cos", "[", "\[Alpha]", "]"}]}], "2"]]}], ")"}], "2"], 
        RowBox[{"Sin", "[", "\[Alpha]", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "0", ",", 
         FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"\"\<double polydisp data \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"Hash", "[", 
       RowBox[{"{", 
        RowBox[{"qlist", ",", "lengths", ",", "radii"}], "}"}], "]"}], "]"}], 
     "<>", "\"\<.mx\>\""}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Unfortunately", " ", "looks", " ", "like", " ", "this", " ", "hash", " ",
      "code", " ", "is", " ", "computer", " ", "specific"}], ",", " ", 
    RowBox[{
    "so", " ", "might", " ", "need", " ", "to", " ", "change", " ", "the", 
     " ", "file", " ", "name", " ", "of", " ", "the", " ", "existing", " ", 
     "table", " ", "to", " ", "this", " ", "name", " ", "if", " ", "you", " ",
      "want", " ", "to", " ", "reuse", " ", 
     RowBox[{"it", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filename", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", "filename"}], "}"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"filename", "=", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", 
        "\"\<double polydisp data 8767617112876749221.mx\>\""}], "}"}], 
      "]"}]}], ";"}], " ", "*)"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "in", " ", "case", " ", "you", " ", "want", " ", "to", " ", "manually", 
    " ", "enter", " ", "the", " ", "file", " ", "name", " ", "for", " ", 
    "the", " ", "hash", " ", "code", " ", "is", " ", "different", " ", "when",
     " ", "generated", " ", "on", " ", "different", " ", "computers"}], 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FileExistsQ", "[", "filename", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dataAllLengths", "=", 
      RowBox[{"<<", 
       RowBox[{"(", "filename", ")"}]}]}], ";"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"SetSharedVariable", "[", "j", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"j", "=", "0"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"dataAllLengths", "=", 
         RowBox[{"Quiet", "[", "\[IndentingNewLine]", 
          RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
               RowBox[{"P11", "[", 
                RowBox[{"qlist", ",", "radius", ",", "length"}], "]"}]}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"length", ",", "lengths"}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"radius", ",", "radii"}], "}"}]}], "\[IndentingNewLine]",
            "]"}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
       "\[IndentingNewLine]", "j"}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dataAllLengths", ">>", 
      RowBox[{"(", "filename", ")"}]}]}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "probability", " ", "density", " ", 
    "function", " ", "and", " ", "function", " ", "to", " ", "calculate", " ",
     "intensities", " ", "with", " ", "both", " ", "L", " ", "and", " ", "R", 
    " ", 
    RowBox[{"unknown", "."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"probfunc", "[", 
    RowBox[{
    "\[Mu]l_", ",", "\[Sigma]l_", ",", "\[Mu]r_", ",", "\[Sigma]r_", ",", 
     "l_", ",", "r_"}], "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"LogMultinormalDistribution", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Mu]l", ",", "\[Mu]r"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox["\[Sigma]l", "2"], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             SuperscriptBox["\[Sigma]r", "2"]}], "}"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "r"}], "}"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l", ">", "0"}], ",", 
        RowBox[{"r", ">", "0"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "intensities", " ", "for", " ", "the", " ", "platelets", 
    " ", "based", " ", "on", " ", "the", " ", "probability", " ", 
    "distributions", " ", "obtained", " ", "with", " ", "the", " ", "form", 
    " ", "factor", " ", 
    RowBox[{"fit", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"note", ";", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "intensity", " ", "is", " ", "now", " ", "corrected", " ", 
      "for", " ", "the", " ", 
      RowBox[{"volume", "^", "2"}]}], "-", 
     RowBox[{
     "dependence", " ", "of", " ", "scattering", " ", "intensity"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"calculateIntensitiesLR", "[", 
     RowBox[{
      RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
      RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"probabilities", ",", "data"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"probabilities", "=", "\[IndentingNewLine]", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"l", "^", "2"}], " ", 
           RowBox[{"r", "^", "4"}], "*", "\[IndentingNewLine]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "+", 
               RowBox[{"radiusstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "r", "]"}], "-", 
               RowBox[{"radiusstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "+", 
               RowBox[{"lengthstep", "/", "2"}]}]], "-", 
             SuperscriptBox["10", 
              RowBox[{
               RowBox[{"Log10", "[", "l", "]"}], "-", 
               RowBox[{"lengthstep", "/", "2"}]}]]}], ")"}], "*", 
           "\[IndentingNewLine]", 
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "volume", " ", "weighing", " ", "for", " ", "a", " ", "cylinder", 
          " ", "of", " ", 
          RowBox[{"diameter", "^", "2"}], " ", "*", " ", 
          RowBox[{"thickness", ".", " ", "We"}], " ", "square", " ", "this"}],
          ",", " ", 
         RowBox[{"because", " ", "intensity", " ", "scales", " ", "with", " ", 
          RowBox[{"V", "^", "2"}]}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"probfunc", "[", 
            RowBox[{
            "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", ",", 
             "l", ",", "r"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "radii"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"probabilities", "=", 
        RowBox[{"probabilities", "/", 
         RowBox[{"Total", "[", 
          RowBox[{"Flatten", "[", "probabilities", "]"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Total", "[", "\[IndentingNewLine]", 
            RowBox[{"Table", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"probabilities", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ".", 
               RowBox[{"dataAllLengths", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "probabilities", "]"}]}], "}"}]}], 
             "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
          "}"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "data", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",\

 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.88900205859529*^9}, {
   3.8890029285899467`*^9, 3.889002953302465*^9}, {3.889061053677486*^9, 
   3.889061062588866*^9}, {3.889077630726709*^9, 3.889077637427123*^9}, {
   3.8890777314446993`*^9, 3.889077747654249*^9}, {3.88907998107436*^9, 
   3.889079982089085*^9}, {3.889080034422716*^9, 3.8890801182358418`*^9}, {
   3.889080169489069*^9, 3.889080169576085*^9}, {3.88949949386611*^9, 
   3.889499567193898*^9}, {3.8894998864287863`*^9, 3.8894998890429115`*^9}, {
   3.889500147504761*^9, 3.8895001771365824`*^9}, {3.8895002362490377`*^9, 
   3.8895002555469923`*^9}, 3.8896807810308504`*^9, {3.8896808952666397`*^9, 
   3.889680897469507*^9}, 3.8896809885482616`*^9, {3.889681435463972*^9, 
   3.889681467825818*^9}, {3.889683285411501*^9, 3.8896833249263334`*^9}, {
   3.8896836624629545`*^9, 3.889683726861018*^9}, {3.889683767007558*^9, 
   3.8896837811495934`*^9}, {3.8909840270444803`*^9, 3.890984036295034*^9}, 
   3.890984239308541*^9, {3.892626838974331*^9, 3.892626898907713*^9}, {
   3.8926270171836615`*^9, 3.8926270218689365`*^9}, {3.8926277730407066`*^9, 
   3.892627776564975*^9}, {3.8926333318437233`*^9, 3.8926333994129653`*^9}, {
   3.9020332262608376`*^9, 3.9020332963358493`*^9}, {3.9020336624352193`*^9, 
   3.9020336629539337`*^9}, {3.9020353079182467`*^9, 
   3.9020353486147013`*^9}, {3.9020363693828735`*^9, 
   3.9020363924630795`*^9}, {3.9034255328232384`*^9, 
   3.9034255543925576`*^9}, {3.903426126619336*^9, 3.903426129784585*^9}, 
   3.9046328541982255`*^9, {3.904633917772386*^9, 3.9046339197876396`*^9}, {
   3.905228211494954*^9, 3.9052282241923895`*^9}, {3.9137976292850857`*^9, 
   3.913797635806909*^9}, {3.9152686179168806`*^9, 3.91526861968119*^9}},
 CellLabel->
  "In[1302]:=",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],

Cell[BoxData["30351"], "Output",
 CellChangeTimes->{3.9058513205308475`*^9, 3.906016935157094*^9, 
  3.907145142887905*^9, 3.9079088535669875`*^9, 3.913786392592598*^9, 
  3.913800257074381*^9, 3.9152686746998463`*^9, 3.91569311189526*^9, 
  3.917498610180668*^9, 3.9175130502955217`*^9, 3.9179436761369123`*^9, 
  3.9185606134321527`*^9, 3.9187270987461877`*^9},
 CellLabel->
  "Out[1315]=",ExpressionUUID->"c7779e7c-ec61-4f95-9b79-7deccb711d30"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Mu]l", "-", 
         RowBox[{"Log", "[", "l", "]"}]}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]l", "2"]}]]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Mu]r", "-", 
        RowBox[{"Log", "[", "r", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]r", "2"]}]]}]], 
  RowBox[{"2", " ", "l", " ", "\[Pi]", " ", "r", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[Sigma]l", "2"], " ", 
     SuperscriptBox["\[Sigma]r", "2"]}]]}]]], "Output",
 CellChangeTimes->{3.9058513205308475`*^9, 3.906016935157094*^9, 
  3.907145142887905*^9, 3.9079088535669875`*^9, 3.913786392592598*^9, 
  3.913800257074381*^9, 3.9152686746998463`*^9, 3.91569311189526*^9, 
  3.917498610180668*^9, 3.9175130502955217`*^9, 3.9179436761369123`*^9, 
  3.9185606134321527`*^9, 3.918727110472129*^9},
 CellLabel->
  "Out[1320]=",ExpressionUUID->"a0730413-1dfa-40d0-aaef-32454205bd5c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{
     "the", " ", "initial", " ", "values", " ", "are", " ", "optional"}]}], 
    ";", " ", 
    RowBox[{
    "if", " ", "you", " ", "omit", " ", "them", " ", "the", " ", "value", " ",
      "after", " ", 
     RowBox[{"the", " ", ":", " ", 
      RowBox[{"will", " ", "be", " ", 
       RowBox[{"assumed", ".", " ", "Fit"}], " ", "slopes", " ", "with", " ", 
       "this", " ", "discrete", " ", "full", " ", "form", " ", "factor", " ", 
       "\"\<function\>\""}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fitSlopeLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}], ",", " ", 
      RowBox[{"binfactor_", ":", "0.15"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dataSlope", "=", 
         RowBox[{"slope", "[", 
          RowBox[{"data", ",", "binfactor"}], "]"}]}], ",", 
        "\[IndentingNewLine]", "qListDataSlope"}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"qListDataSlope", "=", 
        RowBox[{"dataSlope", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"minfuncslopeLR", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"slope", "[", 
             RowBox[{"calculateIntensitiesLR", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
              "]"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Flatten", "[", 
               RowBox[{"Nearest", "[", 
                RowBox[{
                 RowBox[{"qlistslope", "\[Rule]", "\"\<Index\>\""}], ",", 
                 "qListDataSlope"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
           "-", "\[IndentingNewLine]", 
           RowBox[{"dataSlope", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}]}], "]"}], "[", 
         "\"\<Value\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"fmfSLR", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"minfuncslopeLR", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], " ", ",", " ", 
            RowBox[{"\[Mu]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]l", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Mu]r", " ", ">", " ", "0"}], ",", " ", 
            RowBox[{"\[Sigma]r", ">", "0"}]}], " ", "}"}], "*)"}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"constraint", ":", " ", 
           RowBox[{"sigma", " ", ">", " ", "0"}]}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "*)"}], "  ", 
         RowBox[{"(*", " ", "default", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"minfuncslopeLR", "[", 
           RowBox[{
            RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
            RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"AccuracyGoal", " ", "->", " ", "5"}], ",", " ", 
             RowBox[{"PrecisionGoal", " ", "->", " ", "5"}]}], "*)"}], "]"}], 
          "  ", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Try", " ", "to", " ", "reduce", " ", "computation", " ", "time", 
            " ", "by", " ", "asking", " ", "for", " ", "lower", " ", 
            "accuracy", " ", "and", " ", 
            RowBox[{"precision", "."}]}], "*)"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]rinitial"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]rinitial"}], "}"}]}], "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\< \[Mu]r = \>\"", ",", 
             RowBox[{"\[Mu]r", "\"\< \[Sigma]r = \>\""}], ",", "\[Sigma]r"}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"fmfSLR", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], 
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Fit", " ", "the", " ", "entire", " ", "SAXS", " ", "pattern", " ", 
      "with", " ", "the", " ", "platelets", " ", "form", " ", "factor"}], " ",
      "-", " ", 
     RowBox[{"volume", " ", "weighted"}], " ", "-", " ", 
     RowBox[{
     "this", " ", "intensity", " ", "fit", " ", "is", " ", "much", " ", 
      "slower", " ", "than", " ", "the", " ", "slope", " ", "fit", " ", "and",
       " ", "gives", " ", "similar", " ", "results", " ", "for", " ", "the", 
      " ", "lamellae", " ", "form", " ", "factor"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fitIntensityLR", "[", 
     RowBox[{"data_", ",", 
      RowBox[{"\[Mu]linitial_", ":", 
       RowBox[{"Log", "[", "30.", "]"}]}], ",", 
      RowBox[{"\[Sigma]linitial_", ":", "0.5"}], ",", 
      RowBox[{"\[Mu]rinitial_", ":", 
       RowBox[{"Log", "[", "250.", "]"}]}], ",", 
      RowBox[{"\[Sigma]rinitial_", ":", "0.5"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"qListIntensity", "=", 
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"qListDataIntensity", " ", "=", " ", 
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"qListIntensity", " ", "=", " ", 
         RowBox[{"qListIntensity", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"minfuncfullfit", "[", 
         RowBox[{
          RowBox[{"\[Mu]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]l_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Mu]r_", "?", "NumberQ"}], ",", 
          RowBox[{"\[Sigma]r_", "?", "NumberQ"}]}], "]"}], ":=", 
        RowBox[{"Norm", "[", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}], "-", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"calculateIntensitiesLRqlist", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", " ",
               ",", " ", "qListIntensity"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], ";", 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "two", " ", "terms", " ", "not", " ", "of", " ", "equal", " ", 
         "length"}], "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "should", " ", "we", " ", "ask", " ", "a", " ", "scale", " ", 
         RowBox[{"parameter", "?", " ", "scale_", "?", "NumberQ"}], " ", "to",
          " ", "the", " ", "calculateintensity", " ", 
         RowBox[{"function", "?"}]}], "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"solint", "=", 
        RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"minfuncfullfit", "[", 
            RowBox[{
             RowBox[{"Abs", "[", "\[Mu]l", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Sigma]l", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Mu]r", "]"}], ",", 
             RowBox[{"Abs", "[", "\[Sigma]r", "]"}]}], "]"}], "  ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent",
              " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"minfuncfullfit", "[", 
             RowBox[{
             "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
             "]"}], "  ", 
            RowBox[{"(*", " ", 
             RowBox[{
             "take", " ", "absolute", " ", "values", " ", "to", " ", 
              "prevent", " ", "negative", " ", "fit", " ", "results"}], " ", 
             "*)"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"scale", ",", "1"}], "}"}], ","}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Mu]l", ",", "\[Mu]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]l", ",", "\[Sigma]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Mu]r", ",", "\[Mu]linitial"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"\[Sigma]r", ",", "\[Sigma]linitial"}], "}"}]}], 
           "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Print", "[", 
            RowBox[{
            "\"\<\[Mu]l = \>\"", ",", "\[Mu]l", ",", "\"\< \[Sigma]l = \>\"", 
             ",", "\[Sigma]l", ",", "\"\<\[Mu]r = \>\"", ",", "\[Mu]r", ",", 
             "\"\< \[Sigma]r = \>\"", ",", "\[Sigma]r"}], "]"}]}], " ", 
          RowBox[{"(*", 
           RowBox[{
           ",", "\"\< scale = \>\"", ",", "scale", " ", ",", " ", 
            "\"\<, func = \>\"", ",", 
            RowBox[{"minfuncfullfit", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "scale"}], "]"}]}], 
           "*)"}], ","}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Method", "->", "\"\<QuasiNewton\>\""}], " ", "*)"}], 
         RowBox[{"(*", " ", 
          RowBox[{
          "we", " ", "did", " ", "not", " ", "specify", " ", "the", " ", 
           "method", " ", "previously"}], "*)"}], "\[IndentingNewLine]", 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"solint", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "~", "Join", "~", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\[Mu]x", "->", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"\[Mu]", "+", 
                 FractionBox[
                  SuperscriptBox["\[Sigma]", "2"], "2"]}]]}], ",", 
              RowBox[{"\[Sigma]x", "->", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", "\[Mu]"], " ", 
                RowBox[{"\[Sqrt]", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]", "2"]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]", "2"]], "-", "1"}], ")"}]}], 
                  ")"}]}]}]}]}], "}"}], "/.", 
            RowBox[{"solint", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "->", 
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "&"}], "/@", 
           RowBox[{"solint", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "~", "Join", "~", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Mu]lx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]l", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]l", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]lx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]l"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]l", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]l", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}], ",", 
             RowBox[{"\[Mu]rx", "->", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"\[Mu]r", "+", 
                FractionBox[
                 SuperscriptBox["\[Sigma]r", "2"], "2"]}]]}], ",", 
             RowBox[{"\[Sigma]rx", "->", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", "\[Mu]r"], " ", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   SuperscriptBox["\[Sigma]r", "2"]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    SuperscriptBox["\[Sigma]r", "2"]], "-", "1"}], ")"}]}], 
                 ")"}]}]}]}]}], "}"}], "/.", 
           RowBox[{"solint", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "\[IndentingNewLine]", 
        
        RowBox[{"(*", " ", 
         RowBox[{
         "take", " ", "absolute", " ", "values", " ", "to", " ", "prevent", 
          " ", "negative", " ", "fit", " ", "results"}], " ", "*)"}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.8890020072173767`*^9}, {
   3.889002614228364*^9, 3.8890026313484697`*^9}, {3.889077832884159*^9, 
   3.889077894603732*^9}, {3.889080182454623*^9, 3.889080182537393*^9}, {
   3.8890822541823463`*^9, 3.8890822952851562`*^9}, {3.889082341655233*^9, 
   3.889082344557757*^9}, {3.889082656479224*^9, 3.8890826670260477`*^9}, {
   3.8890828570654707`*^9, 3.889082869681726*^9}, {3.889082911422908*^9, 
   3.889082918957836*^9}, {3.8895003750115547`*^9, 3.8895003897150297`*^9}, {
   3.8895018994156485`*^9, 3.8895019010220375`*^9}, {3.889503150539938*^9, 
   3.8895031777290506`*^9}, {3.8896809063671813`*^9, 
   3.8896810153449264`*^9}, {3.8896810571842823`*^9, 
   3.8896811412259593`*^9}, {3.889681489021313*^9, 3.8896815167211204`*^9}, {
   3.8896816106523666`*^9, 3.8896817796390357`*^9}, {3.8896820398977776`*^9, 
   3.889682095914321*^9}, 3.8896821349393435`*^9, {3.889682203278436*^9, 
   3.8896822073970346`*^9}, 3.889682405803105*^9, {3.889683225636203*^9, 
   3.8896832268268085`*^9}, {3.889683264087661*^9, 3.8896832726744494`*^9}, {
   3.8902008849918118`*^9, 3.890200911254434*^9}, {3.891414478168077*^9, 
   3.89141454535581*^9}, {3.8914145789251857`*^9, 3.891414624133849*^9}, {
   3.8914150625685744`*^9, 3.8914152262658043`*^9}, {3.8914159481837835`*^9, 
   3.8914159627995386`*^9}, {3.891417522295415*^9, 3.8914175385413494`*^9}, 
   3.891427879634804*^9, {3.891427987429741*^9, 3.8914280388778486`*^9}, {
   3.8914908223125954`*^9, 3.8914908272757816`*^9}, {3.9034214157801332`*^9, 
   3.9034214559628935`*^9}, 3.9034215153083286`*^9, {3.903421635003624*^9, 
   3.9034216676164503`*^9}, {3.9034217652411594`*^9, 
   3.9034217655448523`*^9}, {3.903421878350258*^9, 3.903421922978465*^9}, {
   3.9034219682375975`*^9, 3.9034221273813486`*^9}, {3.903422167139739*^9, 
   3.9034222293512406`*^9}, 3.903422326229187*^9, 3.903423188186224*^9, {
   3.903423322373499*^9, 3.9034233342236347`*^9}, {3.9034233909444113`*^9, 
   3.9034234363318615`*^9}, {3.9034235328876123`*^9, 3.903423533172177*^9}, 
   3.903423571559184*^9, {3.903423613971017*^9, 3.903423628462083*^9}, 
   3.9034237309258165`*^9, 3.903423784832442*^9, {3.903423869041752*^9, 
   3.903423879202055*^9}, {3.903423920430318*^9, 3.9034239630320497`*^9}, 
   3.903424130613789*^9, {3.903424939479628*^9, 3.9034249554049816`*^9}, {
   3.9034252419827557`*^9, 3.903425251266121*^9}, {3.9034256201581697`*^9, 
   3.9034256635257635`*^9}, {3.9052282458576093`*^9, 3.905228255448001*^9}, {
   3.907839824541335*^9, 3.907839836448653*^9}, {3.907839926226036*^9, 
   3.907839928291877*^9}, {3.907840034205261*^9, 3.9078400370754724`*^9}, {
   3.9078402899263597`*^9, 3.9078403414919567`*^9}, {3.9078406086387076`*^9, 
   3.9078406120886383`*^9}},
 CellLabel->
  "In[1322]:=",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot settings", "Section",
 CellChangeTimes->{{3.9042072693332744`*^9, 
  3.904207274139716*^9}},ExpressionUUID->"105337f8-9f71-463c-ba4f-\
5445b245946c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"inch", " ", "=", " ", "84"}], " ", ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Should", " ", "be", " ", "72", " ", "for", " ", "Mac", " ", "or", " ", 
     "96", " ", "for", " ", "windows"}], ",", " ", 
    RowBox[{
    "but", " ", "somehow", " ", "I", " ", "dont", " ", "obtain", " ", "the", 
     " ", "specified", " ", "image", " ", "sizes", " ", "that", " ", 
     RowBox[{"way", "."}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", " ", "=", " ", 
   RowBox[{"inch", "/", "2.54"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904207973596441*^9, 3.904207974366299*^9}, {
  3.904208548778447*^9, 3.904208549320463*^9}, {3.9042087180049963`*^9, 
  3.904208749302359*^9}},
 CellLabel->
  "In[1324]:=",ExpressionUUID->"e93dc968-6479-4f4d-8783-58aeb15a1214"],

Cell[CellGroupData[{

Cell["\<\
Function to get logarithmic tick marks in scientific notation\
\>", "Subsection",
 CellChangeTimes->{{3.889675803215909*^9, 
  3.889675825628518*^9}},ExpressionUUID->"2c7e915b-284b-4a52-9077-\
42b65bc60a51"],

Cell["\<\
From https://stackoverflow.com/questions/5669073/force-scientific-notation-in-\
tick-labels-of-listloglogplot. \[LineSeparator]Was really annoyed that \
apparently it\[CloseCurlyQuote]s super hard to choose your own tick labels in \
mathematica in combination with logarithmic tick marks\
\>", "Text",
 CellChangeTimes->{{3.8896758423204074`*^9, 3.889675874699585*^9}, {
  3.8896759137086077`*^9, 
  3.8896759250674143`*^9}},ExpressionUUID->"0716ec73-f7da-4d51-adfc-\
df2d5f6b72d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PowerTicks", "[", "label_", "]"}], "[", 
    RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min10", ",", "max10"}], "}"}], ",", 
     RowBox[{
      RowBox[{"min10", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"max10", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", 
              RowBox[{"Superscript", "[", 
               RowBox[{"10", ",", "i"}], "]"}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "min10", ",", "max10"}], "}"}]}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", " ", 
               RowBox[{"10", "^", "i"}]}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
       "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"use", " ", "example"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
     RowBox[{"Frame", "->", "True"}], ",", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}]}], 
    "]"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "skip", " ", "every", " ", "second", " ", "tick", " ", "label", " ", "for",
     " ", "readability"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PowerTicks2", "[", "label_", "]"}], "[", 
    RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min10", ",", "max10"}], "}"}], ",", 
     RowBox[{
      RowBox[{"min10", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"max10", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"10", "^", "i"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{"label", ",", 
                RowBox[{"Superscript", "[", 
                 RowBox[{"10", ",", "i"}], "]"}], ",", 
                RowBox[{"Spacer", "[", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
           "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"k", " ", 
                 RowBox[{"10", "^", "i"}]}], ",", 
                RowBox[{"Spacer", "[", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
         "]"}], "]"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", 
              RowBox[{"Superscript", "[", 
               RowBox[{"10", ",", "i"}], "]"}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", "i"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{"label", ",", " ", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"10", "min10"}], ",", 
            RowBox[{"10", "max10"}], ",", "2"}], "}"}]}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k", " ", 
               RowBox[{"10", "^", "i"}]}], ",", 
              RowBox[{"Spacer", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
       "]"}]}]}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Only", " ", "plot", " ", "1", " ", "out", " ", "of", " ", "3", " ", 
    "tick", " ", "labels", " ", "for", " ", "readability"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerTicks3", "[", "label_", "]"}], "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min10", ",", "max10"}], "}"}], ",", 
    RowBox[{
     RowBox[{"min10", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"Log10", "[", "min", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"max10", "=", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"Log10", "[", "max", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"10", "^", "i"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{"label", ",", 
               RowBox[{"Superscript", "[", 
                RowBox[{"10", ",", "i"}], "]"}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10", ",", "2"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k", " ", 
                RowBox[{"10", "^", "i"}]}], ",", 
               RowBox[{"Spacer", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], "]"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", 
             RowBox[{"Superscript", "[", 
              RowBox[{"10", ",", "i"}], "]"}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "min10", ",", "max10", ",", "3"}], "}"}]}], "]"}],
        ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", "i"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{"label", ",", " ", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"10", "min10"}], ",", 
           RowBox[{"10", "max10"}], ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"k", " ", 
              RowBox[{"10", "^", "i"}]}], ",", 
             RowBox[{"Spacer", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.005", ",", "0.`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Thickness", "[", "0.001`", "]"}], "}"}]}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"i", ",", "min10", ",", "max10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "9"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
      "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.8896758773232393`*^9, {3.8896759377796016`*^9, 3.889675951308181*^9}, {
   3.904191636037596*^9, 3.904191689658992*^9}, {3.904191749911257*^9, 
   3.90419175021442*^9}, {3.9041924745204535`*^9, 3.9041925014087954`*^9}, {
   3.904192735930566*^9, 3.9041928026204376`*^9}, {3.904192834250898*^9, 
   3.904192884253207*^9}, {3.904192951520898*^9, 3.904193158931017*^9}, {
   3.9041932332658277`*^9, 3.904193246485846*^9}, {3.913786902762003*^9, 
   3.9137869463079247`*^9}},
 CellLabel->
  "In[1326]:=",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Title",
 CellChangeTimes->{{3.889081816418654*^9, 
  3.8890818172763433`*^9}},ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-\
520991da3e70"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "EXAMPLE", " ", "plots", " ", "of", " ", "the", " ", "monodisperse", " ", 
     "and", " ", "polydisperse", " ", "form", " ", 
     RowBox[{
     "factors", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "They"}], 
     " ", "are", " ", "very", " ", "similar"}], ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "the", " ", "one", " ", 
      RowBox[{"(", "P11", ")"}], " ", "for", " ", "actual", " ", "disks", " ",
       "is", " ", 
      RowBox[{"better", ":", " ", 
       RowBox[{"the", " ", "form", " ", "factor", " ", "P", 
        RowBox[{"(", "Q", ")"}], " ", "is", " ", "always", " ", "1", " ", 
        "for", " ", "Q"}]}]}], "->", 
     RowBox[{"0.", " ", "For", " ", "the", " ", "lamellae", " ", "P", 
      RowBox[{"(", 
       RowBox[{"Q", "->", "0"}], ")"}], " ", "depends", " ", "on", " ", "the",
       " ", "thickness", " ", "L"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "which", " ", "influences", " ", "results", " ", "when", " ", "fitting", 
      " ", "polydisperse", " ", "cases"}], ";", " ", 
     RowBox[{"see", " ", "slope", " ", "plot", " ", 
      RowBox[{"below", "."}]}]}]}], "\[IndentingNewLine]", " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"Isheets", "[", 
            RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
         "\[Transpose]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"one", " ", "example", " ", "form", " ", "factor"}], " ", "*)"}],
     "\[IndentingNewLine]", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"Isheets", "[", 
             RowBox[{"qlist", ",", "10"}], "]"}]}], "}"}], "\[Transpose]"}], 
         ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"Isheets", "[", 
             RowBox[{"qlist", ",", "40"}], "]"}]}], "}"}], "\[Transpose]"}], 
         ","}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "40"}], "]"}]}], "}"}], 
         "\[Transpose]"}], "*)"}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<P(\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\))\>\"", ",", 
           " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "one", " ", "example", " ", "polydisperse", " ", "form", " ", "factor"}],
      " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
         RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"intPolydisp", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3.3"}]}]}], "]"}], "*)"}], "\[IndentingNewLine]", 
       "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.8", ",", 
          RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"intPolydisp", "[", 
         RowBox[{
          RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3.3"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", 
           RowBox[{"Log", "[", "250.", "]"}], ",", "0.2"}], "]"}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"intPolydisp", "[", 
          RowBox[{
           RowBox[{"Log", "[", "40.", "]"}], ",", "0.6", ",", "qlist", ",", 
           RowBox[{"10", "^", 
            RowBox[{"-", "3.3"}]}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "calculated", " ", "slopes", " ", "for", " ", "one", " ", "example"}], 
     " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"Log", "[", "10.", "]"}], ",", "0.8", ",", 
          RowBox[{"Log", "[", "250.", "]"}], ",", "0.5"}], "]"}], "]"}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{
  3.853833992055169*^9, {3.853838966450965*^9, 3.853838966553301*^9}, {
   3.8544234235752993`*^9, 3.854423436127577*^9}, {3.854430087163003*^9, 
   3.854430130510928*^9}, {3.854430203830633*^9, 3.854430219131062*^9}, {
   3.8601385420212803`*^9, 3.860138638056221*^9}, {3.8601386828025064`*^9, 
   3.860138692836401*^9}, {3.8619498070714016`*^9, 3.861949810669832*^9}, {
   3.864111368481957*^9, 3.864111381547614*^9}, {3.8641119129600077`*^9, 
   3.864111933466826*^9}, {3.86411198099782*^9, 3.8641120377855062`*^9}, {
   3.864112243724079*^9, 3.8641122604900866`*^9}, {3.864112766219705*^9, 
   3.86411278769474*^9}, {3.8641135528767495`*^9, 3.8641135674698086`*^9}, {
   3.8641136364748583`*^9, 3.8641136872689133`*^9}, {3.864115609508887*^9, 
   3.864115696314577*^9}, {3.864115732636894*^9, 3.864115830964185*^9}, {
   3.8641158807267537`*^9, 3.8641158812495947`*^9}, {3.8641159142672977`*^9, 
   3.864115966691824*^9}, {3.8641160299919057`*^9, 3.8641160563528504`*^9}, {
   3.8641161004319696`*^9, 3.8641161468625154`*^9}, {3.8641161798404274`*^9, 
   3.8641161881638513`*^9}, {3.864116300781921*^9, 3.864116303316224*^9}, {
   3.864117598850899*^9, 3.864117610456077*^9}, {3.864117641542405*^9, 
   3.8641176697889366`*^9}, {3.864180413527955*^9, 3.864180439734521*^9}, {
   3.8641804809675617`*^9, 3.8641805484890027`*^9}, {3.864439294957782*^9, 
   3.8644393039048176`*^9}, {3.8644393915786576`*^9, 3.864439422827739*^9}, {
   3.864439453939878*^9, 3.864439469354518*^9}, {3.864439507094865*^9, 
   3.864439508154552*^9}, 3.8644397191828737`*^9, {3.8644398454503803`*^9, 
   3.8644398477143235`*^9}, {3.8644399339387035`*^9, 3.86443994606491*^9}, {
   3.886064903615081*^9, 3.8860649365245705`*^9}, {3.8860649824235754`*^9, 
   3.886065042163972*^9}, {3.8860654296691275`*^9, 3.8860654298245497`*^9}, {
   3.8860658521704564`*^9, 3.886065874983266*^9}, {3.886066040165041*^9, 
   3.886066041373247*^9}, {3.8860666771353765`*^9, 3.8860666867852397`*^9}, {
   3.887182510322879*^9, 3.887182533881962*^9}, 3.887182594924156*^9, {
   3.888309810352276*^9, 3.8883099090736856`*^9}, 3.888309979546259*^9, {
   3.889001517107656*^9, 3.889001521496806*^9}, 3.8890015518214397`*^9, {
   3.8890016534686737`*^9, 3.8890016557649727`*^9}, {3.8890018189941072`*^9, 
   3.8890019390049477`*^9}, {3.889001975497669*^9, 3.889002071551203*^9}, {
   3.88908017920782*^9, 3.8890801792936077`*^9}, {3.8890803042138767`*^9, 
   3.8890803393388777`*^9}, {3.889080399346223*^9, 3.88908039943169*^9}, {
   3.889080432285198*^9, 3.88908043295632*^9}, {3.8890805058626204`*^9, 
   3.889080523792141*^9}, {3.8890805689399967`*^9, 3.88908063626715*^9}, {
   3.889080678277158*^9, 3.889080691158598*^9}, {3.889080803941393*^9, 
   3.889080811995376*^9}, {3.8890808810469437`*^9, 3.889080901180773*^9}, {
   3.889080979216024*^9, 3.889080999782426*^9}, {3.8890813330369587`*^9, 
   3.889081473443778*^9}, {3.889081541759335*^9, 3.8890816493962383`*^9}, {
   3.8890817114954777`*^9, 3.88908172105647*^9}, {3.8890843321238613`*^9, 
   3.889084359480877*^9}, {3.902035503269289*^9, 3.9020355944478807`*^9}, {
   3.902035837321357*^9, 3.90203588455401*^9}, {3.9020364783077593`*^9, 
   3.90203649464856*^9}, {3.902036696218521*^9, 3.9020366965866585`*^9}, {
   3.902043225131276*^9, 3.9020432417891912`*^9}, {3.9041259208181815`*^9, 
   3.9041259361936593`*^9}, 3.9137864128216476`*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"ccb04c64-cfac-4dcb-b945-caef09e3f7b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "convert", " ", "mu_x", " ", "and", " ", "sigma_x", " ", "vs", " ", "mu", 
    " ", "and", " ", "sigma"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"EstimateMu", "[", 
     RowBox[{"mux_", ",", "sigmax_"}], "]"}], ":=", " ", 
    RowBox[{"1.", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"mux", "^", "2"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"mux", "^", "2"}], " ", "+", " ", 
         RowBox[{"sigmax", "^", "2"}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"EstimateSigma", "[", 
     RowBox[{"mux_", ",", " ", "sigmax_"}], "]"}], ":=", 
    RowBox[{"1.", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"1", " ", "+", " ", 
        RowBox[{
         RowBox[{"sigmax", "^", "2"}], "/", 
         RowBox[{"mux", "^", "2"}]}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"250", ",", "10"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateMu", "[", 
    RowBox[{"250", ",", "250"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"EstimateSigma", "[", 
    RowBox[{"300", ",", "205"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.904187513688132*^9, 3.9041876039880114`*^9}, {
  3.904187653771544*^9, 3.9041876715746946`*^9}, {3.904187707307971*^9, 
  3.904187879638977*^9}, {3.9041879197674084`*^9, 3.9041879342178183`*^9}, {
  3.904187969810813*^9, 3.9041879899019427`*^9}, {3.904188067846054*^9, 
  3.904188071783946*^9}, {3.9041881287470827`*^9, 3.904188131018881*^9}, {
  3.904190045834504*^9, 3.904190053733157*^9}, {3.9041901119643707`*^9, 
  3.904190119617751*^9}, {3.9041901633681464`*^9, 3.9041901728146105`*^9}, {
  3.904190227216575*^9, 3.904190260716491*^9}, {3.904719883844332*^9, 
  3.9047199023415794`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"ada8b3f5-d293-4a14-a0eb-400f1f7504a1"],

Cell[BoxData["5.520661557180397`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168699089*^9, 3.913786424197576*^9, 
   3.915268684418701*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"ee3eb1a6-e93a-4862-8013-b5e601087a00"],

Cell[BoxData["0.039984013851751724`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168699089*^9, 3.913786424197576*^9, 
   3.915268684426361*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"7848c754-a775-4980-8d25-12eaafa7de41"],

Cell[BoxData["5.174887327582274`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168699089*^9, 3.913786424197576*^9, 
   3.9152686844327*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"645aa8ce-4720-4cda-ab70-b3dbf463b193"],

Cell[BoxData["0.6190166623466058`"], "Output",
 CellChangeTimes->{{3.9041878285706854`*^9, 3.9041878806855545`*^9}, 
   3.904187936409606*^9, {3.904187977531421*^9, 3.904187990963075*^9}, 
   3.904188072547146*^9, 3.9041881313472977`*^9, 3.904190056689168*^9, {
   3.9041901156058207`*^9, 3.9041901202442627`*^9}, 3.904190173605768*^9, {
   3.904190246732086*^9, 3.904190262096056*^9}, 3.9046434965255637`*^9, 
   3.9047199035306025`*^9, 3.907145168699089*^9, 3.913786424197576*^9, 
   3.915268684440152*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"24d4d792-1a73-4be6-ab4a-c5cbe8603130"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"qlist", ",", 
         RowBox[{"P11", "[", 
          RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
       "\[Transpose]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "1"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "500"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "5"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "100"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "100"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{
         RowBox[{"EstimateMu", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"10", ",", "10"}], "]"}], ",", 
         RowBox[{"EstimateMu", "[", 
          RowBox[{"250", ",", "250"}], "]"}], ",", 
         RowBox[{"EstimateSigma", "[", 
          RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "10000000"}], "}"}]}], "}"}]}]}], 
     RowBox[{"(*", 
      RowBox[{",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}]}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["10", 
          RowBox[{"-", "12"}]], ",", " ", 
         SuperscriptBox["10", "8"]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerTicks3", "[", "True", "]"}], "[", 
          RowBox[{
           SuperscriptBox["10", 
            RowBox[{"-", "14"}]], ",", " ", 
           SuperscriptBox["10", "8"]}], "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"I\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"[\",FontSlant->\"Italic\"]\)a.u.\!\
\(\*StyleBox[\"]\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotRange", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "Automatic", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["10", 
            RowBox[{"-", "14"}]], ",", " ", 
           SuperscriptBox["10", "5"]}], "}"}]}], "}"}]}], ","}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 200 nm\>\"", ",", 
       "  ", "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"L\",FontSlant->\
\"Italic\"]]\) = 10 nm & \!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 500 nm\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactors_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotFormFactors", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9041859453120747`*^9, {3.9041859884525213`*^9, 3.9041860365389853`*^9}, 
   3.904186090409512*^9, {3.904186223611288*^9, 3.904186244710867*^9}, {
   3.9041862958932896`*^9, 3.904186311704144*^9}, {3.9041863552670774`*^9, 
   3.904186397181115*^9}, {3.9041864280776205`*^9, 3.90418643888125*^9}, {
   3.9041864696118755`*^9, 3.904186503017561*^9}, {3.904186533330944*^9, 
   3.9041865934307604`*^9}, {3.904187288923519*^9, 3.904187288978771*^9}, {
   3.9041902799460115`*^9, 3.9041903032587795`*^9}, {3.904190334439412*^9, 
   3.904190338534717*^9}, {3.9041903900473394`*^9, 3.9041905544580836`*^9}, {
   3.9041905916254983`*^9, 3.904190593152613*^9}, {3.904190655323888*^9, 
   3.904190724775958*^9}, {3.90419075487151*^9, 3.9041908138284054`*^9}, {
   3.9041908602529073`*^9, 3.9041910006364913`*^9}, {3.9041910894699326`*^9, 
   3.9041912701373653`*^9}, {3.904191311042491*^9, 3.9041913160712547`*^9}, {
   3.904191352623455*^9, 3.9041913772676783`*^9}, {3.9041914188590918`*^9, 
   3.9041914708604035`*^9}, {3.9041915049699335`*^9, 
   3.9041915118214664`*^9}, {3.904191701059563*^9, 3.904191728788476*^9}, 
   3.904191783947991*^9, {3.904191814782441*^9, 3.9041918162804976`*^9}, {
   3.9041918775355015`*^9, 3.9041919820739117`*^9}, {3.9041920575734663`*^9, 
   3.9041921529063153`*^9}, {3.9041923053514977`*^9, 
   3.9041923131257105`*^9}, {3.904193331301653*^9, 3.904193377447117*^9}, {
   3.9042047245983796`*^9, 3.904204741528363*^9}, 3.9042048871107216`*^9, {
   3.904205639912449*^9, 3.9042057093769984`*^9}, {3.9042057676239934`*^9, 
   3.9042058141770325`*^9}, {3.9042058488982134`*^9, 3.9042058785560975`*^9}, 
   3.904205931283575*^9, {3.904206014545142*^9, 3.9042060247203455`*^9}, {
   3.9042091641681604`*^9, 3.9042091674235477`*^9}, {3.904209209893922*^9, 
   3.9042092114429855`*^9}, {3.904209254270416*^9, 3.90420925726007*^9}, {
   3.904209514824728*^9, 3.904209514974721*^9}, 3.904642270070361*^9, {
   3.904643534636311*^9, 3.9046435350248237`*^9}, {3.9046435661971145`*^9, 
   3.9046435667569866`*^9}, 3.906016972018714*^9, {3.9137869902431793`*^9, 
   3.913787025232712*^9}, {3.9137870595072584`*^9, 3.913787220425132*^9}, 
   3.91378726912676*^9, {3.9137897381457806`*^9, 3.9137898495681086`*^9}, {
   3.913789901400052*^9, 3.9137899330525846`*^9}, {3.913789972360423*^9, 
   3.9137899859404373`*^9}, {3.913790322684202*^9, 3.9137903700606737`*^9}, {
   3.915269044353553*^9, 3.915269050709016*^9}, {3.9152690812975626`*^9, 
   3.9152690817449417`*^9}, {3.9152691207277303`*^9, 3.915269120883769*^9}, {
   3.9152711855322156`*^9, 3.915271243571123*^9}, {3.9152712876185293`*^9, 
   3.915271288547756*^9}, {3.9152716886445646`*^9, 3.9152716964000235`*^9}, {
   3.9152720883673887`*^9, 3.915272169787966*^9}, {3.9152733364974604`*^9, 
   3.9152733619643517`*^9}, {3.917508261702634*^9, 3.9175082907059164`*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"ec4e3acb-9558-468a-9a3b-fca0ee179085"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 170, 19, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169805901084`*^9, 3.9137864326747007`*^9, 
   3.9137870010565467`*^9, 3.9137870328734183`*^9, {3.913787151323208*^9, 
   3.913787197324025*^9}, 3.9137872328119917`*^9, {3.9137897715090313`*^9, 
   3.913789795271342*^9}, {3.913789836863626*^9, 3.913789858461364*^9}, 
   3.913789910688072*^9, 3.913789941619216*^9, {3.91378998037647*^9, 
   3.9137899953042803`*^9}, {3.9137903433311777`*^9, 3.913790380646057*^9}, 
   3.915268694019395*^9, 3.9152690603039694`*^9, 3.9152690903220034`*^9, 
   3.9152691299378653`*^9, 3.9152713136465297`*^9, 3.9152717057150173`*^9, 
   3.9152721155592427`*^9, {3.915272156366107*^9, 3.915272181184827*^9}, 
   3.9152733720320835`*^9, 3.9174986622779956`*^9, {3.9175082811638584`*^9, 
   3.917508302686754*^9}},
 CellLabel->
  "During evaluation of \
In[170]:=",ExpressionUUID->"9ea4289b-6a36-4947-8ce6-2472120e6304"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 170, 20, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169805901084`*^9, 3.9137864326747007`*^9, 
   3.9137870010565467`*^9, 3.9137870328734183`*^9, {3.913787151323208*^9, 
   3.913787197324025*^9}, 3.9137872328119917`*^9, {3.9137897715090313`*^9, 
   3.913789795271342*^9}, {3.913789836863626*^9, 3.913789858461364*^9}, 
   3.913789910688072*^9, 3.913789941619216*^9, {3.91378998037647*^9, 
   3.9137899953042803`*^9}, {3.9137903433311777`*^9, 3.913790380646057*^9}, 
   3.915268694019395*^9, 3.9152690603039694`*^9, 3.9152690903220034`*^9, 
   3.9152691299378653`*^9, 3.9152713136465297`*^9, 3.9152717057150173`*^9, 
   3.9152721155592427`*^9, {3.915272156366107*^9, 3.915272181184827*^9}, 
   3.9152733720320835`*^9, 3.9174986622779956`*^9, {3.9175082811638584`*^9, 
   3.917508302708186*^9}},
 CellLabel->
  "During evaluation of \
In[170]:=",ExpressionUUID->"09cb7016-8124-45dc-80d6-28d0566db65c"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 170, 21, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169805901084`*^9, 3.9137864326747007`*^9, 
   3.9137870010565467`*^9, 3.9137870328734183`*^9, {3.913787151323208*^9, 
   3.913787197324025*^9}, 3.9137872328119917`*^9, {3.9137897715090313`*^9, 
   3.913789795271342*^9}, {3.913789836863626*^9, 3.913789858461364*^9}, 
   3.913789910688072*^9, 3.913789941619216*^9, {3.91378998037647*^9, 
   3.9137899953042803`*^9}, {3.9137903433311777`*^9, 3.913790380646057*^9}, 
   3.915268694019395*^9, 3.9152690603039694`*^9, 3.9152690903220034`*^9, 
   3.9152691299378653`*^9, 3.9152713136465297`*^9, 3.9152717057150173`*^9, 
   3.9152721155592427`*^9, {3.915272156366107*^9, 3.915272181184827*^9}, 
   3.9152733720320835`*^9, 3.9174986622779956`*^9, {3.9175082811638584`*^9, 
   3.917508302727916*^9}},
 CellLabel->
  "During evaluation of \
In[170]:=",ExpressionUUID->"248f9d42-ca23-4648-a328-b5f9e8e5b97d"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 170, 22, 17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.9041903476503673`*^9, 3.9041904017775154`*^9, 3.9041905027666492`*^9, 
   3.9041906018969316`*^9, {3.904190728878871*^9, 3.90419077680774*^9}, 
   3.904190815310687*^9, {3.904190866069703*^9, 3.9041908855758443`*^9}, {
   3.9041909306669903`*^9, 3.9041909684527044`*^9}, {3.904191112816313*^9, 
   3.9041911394359426`*^9}, 3.904191247938362*^9, 3.9041913251792145`*^9, 
   3.9041914794670067`*^9, 3.904191519304845*^9, 3.904191718500889*^9, 
   3.9041917681407013`*^9, 3.9041917995873785`*^9, 3.904191833759548*^9, 
   3.904191907747409*^9, 3.904192174589713*^9, 3.904193268278182*^9, {
   3.9041933575281096`*^9, 3.904193385425242*^9}, {3.9042047333251095`*^9, 
   3.9042047529909153`*^9}, 3.9042048972386117`*^9, 3.9042056815393963`*^9, 
   3.904205720803976*^9, 3.904205806703966*^9, 3.9042060338677483`*^9, 
   3.9042091771834946`*^9, 3.9042092234745193`*^9, 3.9042092673653674`*^9, 
   3.9042095240058827`*^9, 3.904643506284607*^9, 3.904643542944968*^9, 
   3.9046435742253056`*^9, 3.9060169805901084`*^9, 3.9137864326747007`*^9, 
   3.9137870010565467`*^9, 3.9137870328734183`*^9, {3.913787151323208*^9, 
   3.913787197324025*^9}, 3.9137872328119917`*^9, {3.9137897715090313`*^9, 
   3.913789795271342*^9}, {3.913789836863626*^9, 3.913789858461364*^9}, 
   3.913789910688072*^9, 3.913789941619216*^9, {3.91378998037647*^9, 
   3.9137899953042803`*^9}, {3.9137903433311777`*^9, 3.913790380646057*^9}, 
   3.915268694019395*^9, 3.9152690603039694`*^9, 3.9152690903220034`*^9, 
   3.9152691299378653`*^9, 3.9152713136465297`*^9, 3.9152717057150173`*^9, 
   3.9152721155592427`*^9, {3.915272156366107*^9, 3.915272181184827*^9}, 
   3.9152733720320835`*^9, 3.9174986622779956`*^9, {3.9175082811638584`*^9, 
   3.917508302746111*^9}},
 CellLabel->
  "During evaluation of \
In[170]:=",ExpressionUUID->"e8c78226-3696-4e82-9c24-6065114f4866"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgk4VOsfx8fS2Blmn7GNQZay71f3uFFJKVeKf0QprcrWciOtFEolKgmF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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgs4lGkbx2fGrEMMw8yYYxinhMKgg2163o6SDg4VG5Vo1ZYO+Nqlw8qm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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lgk4lGsbx8dgjGWYfd4ZyxgMUqQiLXiecyii7aRzKKLQ9mmj5bSfOmnR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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lgtYjGkbx0eH6TiamWaaUzPNOx11wrYObel5tiwpOmxyWGwHZVF9ZNmW
HIqQQ6wtJIdNaS19aqPWRnnukkhZhyKKNhWRJOmI8vW972uua6655nrnft77
/t///29eKnzVt5FaHA6navT9/8/MT/uP7D6pgPFeVycWz9fg0AX20eFrFGDx
puurumANVhdUeHzlNXrdLlNaHqTB/xqECIQiBeiVnr6yOVCDfwsfan3ZJoeB
nNPVuv4aHHI59a+yIjn4HYjf9u1sDbYQOe86skMOL4a3V4XM0uCm6BuLYufL
4bXVG7ndDA0+cS3ceZadHIy6nyXneGrw96phDjUkA/Hu/vN3PTRYFXe4drBK
Bl+XpJTlfKXBT25P/P1OhgyeT6sIlU/W4ON2NT//ESWDawsPXLadOFqfuMw3
wV0G/BvJcdccNFjZwFEt4Mmg0md2QYf1aP0XR7vHN0mhekXTUIrFaP2eSVf1
8qXwLlk/OEeqwUvabh/8d4sUiiKMXG0Eo/XTVi6/GCCFyfn39+saaPDjgzpu
+ykp7H7LuTSFo8HHuk7wfuiRAGl8mPpnP4UXz3Rt9rgqgcy8wo1LOylsnll7
3ixNAgKP16FeTyncOBizvStCAp76JZWe9yl8NFB/QeUkCRjcD2gKukHhRWez
7E9wJfBSP+rg8ksUVmhPG15XbwaHDMvz1uRSuGFR/e05f5hB7qqkJ0uPUjij
MDbLer0ZZJ4Z/8xpN4W/4xmvG55lBk3codLyOArLl/0+877cDHgzektFERR+
dAXLz70SQ1+B8LqZP4WPSBo7k0rE4LJpZH3JVAovXL2OLE4RQ4jfxZj3agpL
q0x+/fJ7MXhX/DeqUo/CD6mzEcbjxXDPrDlf8lqNj2yYPqXtkwgGc+Y6tt9R
4wW1TQYld0Tg7lz5z/gLaixzXP849aQIFC1Tr3elqnF9kml+1BoR5Pptu2X5
oxqnPzmX6OUlgmJBzNK7AWo8f7L3XIVIBKvdovnDjmos3d9i867NFLIMfkrN
1xutb984dLPIFECazusos8CHsaQma4cprB9KaCmOtcDzjxSc2DDfFFKuRyX0
qiywpMc39ls7U8i7u8m3skqFH/g897IfEkKt7eVzYWtU+FB2gpnWTSFoi+39
RqQqPO+j/OWjDCGkD1ZwHpYqsTi46HJBlBAqhraucQpT4vvn/PftchfCUPPH
DA9tJT7I7QgN4wkh3lhHx/eUOQ4OSXJxbRJA7B6Tkf3TzbHobxVXkC+ACtPM
JzPaFLiOX/zwxRYBbHi/OzR7mwKnrQjKhQABVHamLrynUeC55a83pVMC4Fot
Kxksk2ORIjlgdQ8fYpP1zV3C5LjuR42l91U+DG91yz7IkePUmpI+izQ+dBV6
b3XMlOEg6/k3BiL4kNa6rvwjkmHTzW8zbk/iw4xvpi7TbZbi2gd7Yk5z+TAo
LbyIE6TYOmR2wkieCXQfOJSTo5biU/xE67wAE9jdCvxxZRJsVV50c0nPWIi7
R3quhElw9o8dq3hpYyG0ccvsRVoSbGltIS6dNBYO91bX9WSZ4awHQZei63nw
89vKyHgvM6xJTg4xX8+DhyYNzp2tYpzlWqpTI+dB1lndomlJYqx59fZMfIkx
yJrenVthJcYnj9n4O3xvDAU7ystXVogw5beot+GTEdzy3zXDPUKEGV4ZgaD0
eMcjbRHLJyMo+2EkDmWbsjwyhJasX39d7mnK8scQ7vy5PDngqZDljSHYnBQ4
9WwRsnwxgM3nKslMlZDliQFoYccGnxIBNqf5YQCGpVMjexcK8DGaF/pwSP30
gPsAn+WDPsw4tK9WnsZneaAHMbLWhu0T+Gz+9SBD6y+L9nQTNu968IXLKfH5
22PZfHOB55QtDdYdy+aZC0vmHG3/y5XH5pcL0Xo4qiTamM2rLuxMcT/pfcII
y+h86sJMr0U73f8xxOl0HnVgcWyoXtxHAyyh86cDKXNQW52dAT5M500HsiXo
zIQgfTZf2uAWmX40PF6PzZM2CDiG+fgkl82PNijzmjedqNBl86IF7550Tp/z
TIfNhxZQ0a2tCm0dNg9aEJB/tuWBUhuLaf+PgRt+8o3ek7RYv4+BlHGX86bO
GoNNaX9zwNNVOTdmIYf1MwfuTK3aPLd6BDH+5UB8SPz18MaPyIr26yfiubOf
u6PlPbKk/TlCul+svevWPIgo2o8jxJsYB36q7Udq2n/DZOuKKa2zSnuRmvbb
R5KU7XIn9WgPsqD99YH4DvhYBP+nGylpP30g4311JLyVnUhJ++c94fj85vpN
UztS0H4ZIru0J92fM7UVWdD+GCJi216XeV2PkYr2wyBJv+li3OhSi5T0/gfI
tKqsMw82lyNzet/9pLYgxq9FsI8o6P32EypsadKbS5VETu+zj6ydvTdvrf4D
IqX310s8j2lVT1jfTJh9vSN1wro3zbznhNnPO/L0eFDUgvJXhNlHD6kM6uN/
Wd1NGP68JS9980JvVbwjjN7d5PWugXkHb/UTIa1vN9m0VFL9oW2IMHp2Eb9X
hTwPw2FC0fq9JkX9l40nqjigovV6RSIUPrNkpWPAnNang0S5d4lVYdogp/V4
SSpczx5cZqALUnr+dtKhU/z2QyEXJPS8z8ljtylbasL1wZSer43cHZw+oUBg
CEJ6nlaiPRC/fx0YAZ/u/ykZSG6c3hLDAx7dbzPRuqO6USU1ARnd3xOSV5Hj
ZhTKB2u6nwYSPLL+P9ETBaCm719PtPcOBtpzhGBO36+OJEWtDNStEYKcPv8u
ET/zC/w3zRTs6PNukQhI0in5TgQauv46+RAwO/uKUgwS+vdlRGi3aa51kxgs
6esXSVLAtnbPY2ZgTX8/TfRrEs/ELZAAh30tPCC0sjeVgg1zHbWsi/wJaqRA
MfVoa2JnZcZ22efz0creJ0ITDzl7/nVU/eibmGX9cnBg+kPi3tbDjXmKz/2j
iUsOVWb8YA5KZj50yc4xsFyt/Dw/csu1FUU0KD/rg+b19HjtTFPBOEY/9GX/
8Y32/hYgYfRFF5bO6NboqkHG6I/8N1745Xm4GhTMflC9eWXuQ1CDitkfyotP
8HmrosCC2S/az9+cZreJYvVrR3+HhHnHNVIgY/yBtK2TjOtdNZ/9gy7eszvm
ma4BJo+vUEymf31RvwZY/6GfV0aUOAVbgobxJ5pwCgf9ccESGD50o9Npe3+x
EloB62/UV7xnStZqK2D9j0LCxxDqthWYMflAqptz3E85WQObH9T5KXiew15r
YPOFbBsW4+IOa2CeX3pRfW7Z5YBZNsDmE5Vl5av6TtsAm1903tlhyVmuLTA8
70d3iw8L1kXaApt/NOQOid9V2ALLB/Qi7sjxUEs7YPmBDiUG9qVstQM1wxcU
UX711MundkAx/EFB7Xou8V+PAw3DJ6TkJkb6nBwHlgy/0MvzO7ghY+zBiuEb
8r0Ymwlh9mDN8A+hvRucfyq3BxuGj2hnQvS17ZYOrJ4jyKavcHJvkgOwfEWL
C2v+rHjuAAwfONh+yrLQQW9HYPmMd67+wmxfriMwzyccfMl/VV/iWCdg+Y4p
y+rxt2KdWP3H4OiklbWR952A/X/A6bED+R6uzuw+tHDy5LXzZx53hv8BpzrX
wg==
         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJwtlglYjGsbx1OjUqZma6aZapq9mmnhEDrK8zjWLKeQRBKRUCTrQbKnLKfv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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -27.631021115928487`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"I\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*StyleBox[\\\"[\\\",FontSlant->\\\"Italic\\\"]\\)a.u.\\!\\(\\*StyleBox[\\\"]\
\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "14"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000], \
-322.3619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000], \
-315.45415774018426`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-
           Log[100000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000], \
-308.54640246120215`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000], \
-301.63864718222], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000], \
-287.8231366242557], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000], \
-274.00762606629144`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000], -260.19211550832716`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000], -246.3766049503629], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000], -232.56109439239862`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000], -218.74558383443434`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000], -204.93007327647007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000], -191.1145627185058], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000], -177.29905216054152`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000], -163.48354160257725`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
], -149.66803104461297`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000], \
-135.8525204866487], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000], \
-122.03700992868443`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000], \
-108.22149937072015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000], -94.40598881275588], 
          
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000], -80.5904782547916], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000], -66.77496769682732], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000], -52.95945713886305], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000], -39.14394658089878], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000], 29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000], 43.74911676688687], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000], 57.564627324851145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000], 71.38013788281542], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000], 85.19564844077969], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000], 
           99.01115899874397], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000], 
           112.82666955670824`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000], 
           126.64218011467251`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000], 
           140.4576906726368], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000000],
            147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0], 154.27320123060107`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000], 161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000], 168.08871178856535`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000], 174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000000], 181.90422234652962`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000000], -31.543044121356694`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 3]], -31.13757901324853], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000000], -30.84989694079675], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000000], -30.626753389482538`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000000, 3]], -30.444431832688583`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 7]], -30.290281152861326`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000000], -30.156749760236803`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 9]], -30.03896672458042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-27.631021115928547`, 18.420680743952367`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 20 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 20 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 200 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 500 nm\""}, "PointLegend",
       DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.904190763927281*^9, 3.904190784847489*^9}, 
   3.904190824216564*^9, {3.9041908750426626`*^9, 3.9041908951417494`*^9}, {
   3.90419093959441*^9, 3.9041909781694927`*^9}, {3.904191121526598*^9, 
   3.9041911485886297`*^9}, 3.9041912493882833`*^9, 3.9041913268265076`*^9, 
   3.9041914725880456`*^9, 3.9041915206280174`*^9, 3.9041917197907605`*^9, 
   3.9041917697979903`*^9, 3.9041918009237113`*^9, 3.904191835105816*^9, 
   3.9041919091400146`*^9, 3.904192175933033*^9, 3.9041932696302547`*^9, {
   3.9041933594928875`*^9, 3.9041933875926466`*^9}, {3.9042047353702946`*^9, 
   3.9042047557258425`*^9}, 3.9042048991217747`*^9, 3.9042056832623467`*^9, 
   3.904205723474777*^9, 3.904205808783654*^9, 3.9042060356711893`*^9, 
   3.904209179419348*^9, 3.9042092257431755`*^9, 3.904209269727947*^9, 
   3.904209525940782*^9, 3.9046435079749603`*^9, 3.9046435450459347`*^9, 
   3.904643576099083*^9, 3.9060169825663996`*^9, 3.913786435077738*^9, 
   3.9137870028475466`*^9, 3.913787034570162*^9, {3.9137871530134535`*^9, 
   3.9137871995264134`*^9}, 3.9137872355467205`*^9, {3.9137897732102947`*^9, 
   3.913789797004684*^9}, {3.9137898386542573`*^9, 3.9137898606467037`*^9}, 
   3.9137899123734293`*^9, 3.91378994328424*^9, {3.9137899820695753`*^9, 
   3.9137899974410863`*^9}, {3.9137903450243917`*^9, 3.913790382795354*^9}, 
   3.915268698960551*^9, 3.9152690629301586`*^9, 3.915269093602203*^9, 
   3.9152691333378315`*^9, 3.9152713161485243`*^9, 3.9152717083880987`*^9, 
   3.915272118211128*^9, {3.9152721589705553`*^9, 3.915272184673689*^9}, 
   3.915273374868001*^9, 3.917498664881932*^9, {3.917508283923381*^9, 
   3.917508305862131*^9}},
 CellLabel->
  "Out[170]=",ExpressionUUID->"e4950ae0-adec-4bf8-a910-9f4cef0f9670"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactors_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{{3.904190763927281*^9, 3.904190784847489*^9}, 
   3.904190824216564*^9, {3.9041908750426626`*^9, 3.9041908951417494`*^9}, {
   3.90419093959441*^9, 3.9041909781694927`*^9}, {3.904191121526598*^9, 
   3.9041911485886297`*^9}, 3.9041912493882833`*^9, 3.9041913268265076`*^9, 
   3.9041914725880456`*^9, 3.9041915206280174`*^9, 3.9041917197907605`*^9, 
   3.9041917697979903`*^9, 3.9041918009237113`*^9, 3.904191835105816*^9, 
   3.9041919091400146`*^9, 3.904192175933033*^9, 3.9041932696302547`*^9, {
   3.9041933594928875`*^9, 3.9041933875926466`*^9}, {3.9042047353702946`*^9, 
   3.9042047557258425`*^9}, 3.9042048991217747`*^9, 3.9042056832623467`*^9, 
   3.904205723474777*^9, 3.904205808783654*^9, 3.9042060356711893`*^9, 
   3.904209179419348*^9, 3.9042092257431755`*^9, 3.904209269727947*^9, 
   3.904209525940782*^9, 3.9046435079749603`*^9, 3.9046435450459347`*^9, 
   3.904643576099083*^9, 3.9060169825663996`*^9, 3.913786435077738*^9, 
   3.9137870028475466`*^9, 3.913787034570162*^9, {3.9137871530134535`*^9, 
   3.9137871995264134`*^9}, 3.9137872355467205`*^9, {3.9137897732102947`*^9, 
   3.913789797004684*^9}, {3.9137898386542573`*^9, 3.9137898606467037`*^9}, 
   3.9137899123734293`*^9, 3.91378994328424*^9, {3.9137899820695753`*^9, 
   3.9137899974410863`*^9}, {3.9137903450243917`*^9, 3.913790382795354*^9}, 
   3.915268698960551*^9, 3.9152690629301586`*^9, 3.915269093602203*^9, 
   3.9152691333378315`*^9, 3.9152713161485243`*^9, 3.9152717083880987`*^9, 
   3.915272118211128*^9, {3.9152721589705553`*^9, 3.915272184673689*^9}, 
   3.915273374868001*^9, 3.917498664881932*^9, {3.917508283923381*^9, 
   3.917508308930679*^9}},
 CellLabel->
  "Out[171]=",ExpressionUUID->"be29532c-be6c-4fd7-9af4-1e4ea9e81a54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"qlist", ",", 
          RowBox[{"P11", "[", 
           RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
        "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "1"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
         "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Monodisperse\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ",", " ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 200 nm\>\"", ",", 
       "  ", "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"L\",FontSlant->\
\"Italic\"]]\) = 10 nm & \!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 500 nm\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopes_R250_L10.pdf\>\""}], "}"}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.904204148977622*^9, 3.9042042501767282`*^9}, {
   3.904204287251051*^9, 3.9042042881103563`*^9}, {3.904204324074394*^9, 
   3.904204353252767*^9}, 3.9042043944755707`*^9, {3.9042044389779544`*^9, 
   3.904204458576953*^9}, {3.9042045052605157`*^9, 3.904204571418418*^9}, {
   3.904204614961651*^9, 3.904204699388088*^9}, 3.9042048775437136`*^9, {
   3.9042053883657856`*^9, 3.904205388932059*^9}, {3.904205424667331*^9, 
   3.9042054255500813`*^9}, {3.904206103786495*^9, 3.904206109684391*^9}, {
   3.9042091183959017`*^9, 3.904209143173911*^9}, {3.9046435906976852`*^9, 
   3.9046435910249367`*^9}, 3.9060169815833635`*^9, {3.9152691560061193`*^9, 
   3.9152691621202183`*^9}, 3.915271563240252*^9, 3.9152717051290693`*^9, 
   3.9152733832646103`*^9, {3.9174985831048822`*^9, 3.9174985834128304`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"8216ce0b-9b35-4c62-acff-591ffe4f31e6"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4302.21474091715`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 162, 7, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9152691731859703`*^9, 3.9152715733810515`*^9, 
  3.915271766513014*^9, 3.9152733932182016`*^9, 3.917498680684187*^9},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"abcff84f-e6c0-40ff-a830-97d2fd435b87"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4281.030879488564`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 162, 8, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9152691731859703`*^9, 3.9152715733810515`*^9, 
  3.915271766513014*^9, 3.9152733932182016`*^9, 3.917498680709298*^9},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"5fc36753-1a15-4ff0-954c-0d27abf734d0"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"4260.060152605499`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 162, 9, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9152691731859703`*^9, 3.9152715733810515`*^9, 
  3.915271766513014*^9, 3.9152733932182016`*^9, 3.9174986807265368`*^9},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"7107f5d7-0ff6-4f13-abe4-ba286fce1d3a"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 162, 10, 17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9152691731859703`*^9, 3.9152715733810515`*^9, 
  3.915271766513014*^9, 3.9152733932182016`*^9, 3.917498680742131*^9},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"e88ad506-4ba6-4694-a12d-be5173c48e9d"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJwdknk8FAgfxucyjIZmzLjG8rIhq4PVSsqRFNG6ybmUaFWkUqHIkQ4RWzvK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         "]], 
        LineBox[{{-0.15897359698658403`, 
         0.}, {-0.11512925464970238`, -1.6287746525129954`}, \
{-0.0690775527898214, -3.47315360659058}, {-0.037921523974685165`, -5.}}], 
        LineBox[{{0.4181125955120058, 0.}, {
         0.43749116766886903`, -2.2035933738520566`}, {
         0.4592548101070294, -5.}}], 
        LineBox[{{1.0300566618934435`, 0.}, {
         1.0361632918473205`, -2.7912051877389294`}, {
         1.0405805788006257`, -5.}}], 
        LineBox[{{1.4030544629840807`, 0.}, {
         1.404576906726368, -2.0079076160471723`}, {1.406616190220153, -5.}}], 
        LineBox[{{-0.4630091954351677, -5.}, {-0.45558763115351936`, 0.}}], 
        LineBox[{{0.228351298675993, -5.}, {0.23165559146828285`, 0.}}], 
        LineBox[{{0.6388805057950484, -5.}, {0.6418271126351097, 0.}}], 
        LineBox[{{0.7712896436868366, 0.}, {0.7913156694506129, -5.}}], 
        LineBox[{{0.9206531506765594, -5.}, {0.922823593514723, 0.}}], 
        LineBox[{{1.148580701936892, -5.}, {1.1506253823231076`, 0.}}], 
        LineBox[{{1.232974324436615, 0.}, {1.2404666107865674`, -5.}}], 
        LineBox[{{1.3325406971710336`, -5.}, {1.3345793895516362`, 0.}}], 
        LineBox[{{1.4747166083386538`, -5.}, {1.476581691130728, 0.}}], 
        LineBox[{{1.5454662411386455`, 0.}, {1.5483748203367542`, -5.}}], 
        LineBox[{{1.6118059464218635`, -5.}, {1.6134630565154207`, 0.}}], 
        LineBox[{{1.6728481717421073`, 0.}, {1.675795498224752, -5.}}], 
        LineBox[{{1.7423368266672223`, -5.}, {1.7475824435325478`, 0.}}], 
        LineBox[{{1.784443588757234, 0.}, {1.786808128178082, -5.}}], 
        LineBox[{{1.8414204048096063`, -5.}, {1.8430619614124528`, 0.}}], 
        LineBox[{{1.8846481089094325`, 0.}, {1.8861050511640203`, -5.}}], 
        LineBox[{{1.933963364019762, -5.}, {1.9352909742520752`, 0.}}], 
        LineBox[{{1.9838264927609561`, 0.}, {1.985440323567661, -5.}}], 
        LineBox[{{2.026707434680225, -5.}, {2.02883324280162, 0.}}], 
        LineBox[{{2.084133064413623, 0.}, {2.0877508433225147`, -5.}}], 
        LineBox[{{2.1569101102114057`, -5.}, {2.1610871000057172`, 0.}}], 
        LineBox[{{2.2126654353104493`, 0.}, {2.2166588091265904`, -5.}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJwdkXk4FPoexmezbzNm7OGQytGiVBiEkyg6SiJCiCkk3JKTLIkmElpEIebK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         "]], 
        LineBox[{{-0.18912891794140432`, 
         0.}, {-0.16118095650958336`, -0.8429568033871891}, \
{-0.11512925464970238`, -2.3144563872966364`}, {-0.0690775527898214, \
-3.850264785832737}, {-0.03422064900070915, -5.}}], 
        LineBox[{{0.2191620218793971, -5.}, {
         0.25328436022934525`, -1.2651297537558852`}, {0.2734778595444722, 
         0.}}], 
        LineBox[{{0.3775415550693827, 0.}, {
         0.3914394658089881, -0.5878832309982955}, {
         0.43749116766886903`, -3.0674326845130793`}, {
         0.4747506711141584, -5.}}], 
        LineBox[{{0.628400956818512, -5.}, {
         0.6677496769682738, -2.4099173594567946`}, {
         0.7138013788281548, -1.26589381541168}, {
         0.7598530806880354, -2.3366020947992134`}, {
         0.8059047825479155, -4.158425467846489}, {0.8410321374878849, -5.}}], 
        LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAATFQlwL7x7D8AAAAAAAAUwCIlHxW9
Ne4/If/SsqOWEMAlX0yA/q7vP6guCM6rZwrAk8y89R+U8D+sk+xSZ/4LwJRp
U6vAUPE/7hv0u0qAEMCVBupgYQ3yP9DKY9MzzBDAlqOAFgLK8j+yZoQ+yScQ
wJhAF8yihvM/pf3aDREYEMCY3a2BQ0P0P58KzRKZ7w/AmnpEN+T/9D/qDQC7
ncwPwJoX2+yEvPU/qCbH8wmBEMCbtHGiJXn2Pw938Lp0ERDAnFEIWMY19z9G
+0cMBgAPwJ7ung1n8vc/8hbj9H3tD8CeizXDB6/4P9XN7EhUOg/AoCjMeKhr
+T+mAh6ZH2QPwKDFYi5JKPo/fg3ED/F+EMCiYvnj6eT6PyTlfhBRixDAov+P
mYqh+z+O2kKBICQPwKScJk8rXvw/rhwe8Z0tD8CkOb0EzBr9P1gZtSdUsRDA
ptZTumzX/T8YXn7krI4QwKRz6m8NlP4/FThLZcDhD8CjEIElrlD/P37ma13n
ABDA0taLbacGAEC7b2c1zJ4PwFIlV8j3ZABAptGx5JEKD8DUcyIjSMMAQOx7
e6+g7g/AVMLtfZghAUBZUVNw6sMQwNQQudjofwFAcesduREOEMBUX4QzOd4B
QFIVfac4cA3A1q1Pjok8AkDYdca8FWUMwOe48Tg=
         "]], 
        LineBox[{{-0.47775712476021676`, -5.}, {-0.4415689391967122, 0.}}]}, {
       
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lXk4VesXx49zOGZnn4HDESGiIl2lkthCt1KGDJEMJSnRRXKVDCmNSIVM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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw9VXs4VHsbHbdxGzN73I0itzjU0UnIrT2SnEiRQdKhJJci1Omr5FqI4nRI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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9VXk4VXsbPQ6OmW2e5yElKVGm7FOSlMqYMSSlkivTNWRoIEnDFZXkSkRS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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Monodisperse\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 1 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 20 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 20 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 200 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 500 nm\""}, "PointLegend",
       DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9042042765227785`*^9, {3.904204338079912*^9, 3.904204357267268*^9}, {
   3.9042044406780567`*^9, 3.9042044544205294`*^9}, {3.904204554960986*^9, 
   3.9042045725501585`*^9}, {3.9042046337950153`*^9, 3.904204660172227*^9}, 
   3.904204708579156*^9, 3.9042049269127426`*^9, 3.904205398465316*^9, 
   3.904205436525323*^9, 3.904206119723288*^9, 3.904206218547572*^9, {
   3.904209128373577*^9, 3.904209156913768*^9}, 3.906017002944087*^9, 
   3.91378645121559*^9, 3.915268716888956*^9, {3.9152691601016316`*^9, 
   3.9152691764902477`*^9}, 3.9152715758460083`*^9, 3.9152717691519213`*^9, 
   3.9152733962178035`*^9, 3.917498683678345*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"ba2abfaf-76df-4e59-a69a-6c2994eeb0cc"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactorsSlopes_R250_L10.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9042042765227785`*^9, {3.904204338079912*^9, 3.904204357267268*^9}, {
   3.9042044406780567`*^9, 3.9042044544205294`*^9}, {3.904204554960986*^9, 
   3.9042045725501585`*^9}, {3.9042046337950153`*^9, 3.904204660172227*^9}, 
   3.904204708579156*^9, 3.9042049269127426`*^9, 3.904205398465316*^9, 
   3.904205436525323*^9, 3.904206119723288*^9, 3.904206218547572*^9, {
   3.904209128373577*^9, 3.904209156913768*^9}, 3.906017002944087*^9, 
   3.91378645121559*^9, 3.915268716888956*^9, {3.9152691601016316`*^9, 
   3.9152691764902477`*^9}, 3.9152715758460083`*^9, 3.9152717691519213`*^9, 
   3.9152733962178035`*^9, 3.917498684527988*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"6cbbbc55-ad7c-42d5-ba64-681f60cc181d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"qlist", ",", 
           RowBox[{"P11", "[", 
            RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
         "\[Transpose]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "1"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "10"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ","}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "10"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "100"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "100"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "10"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
         "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ","}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", " ", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
          RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
          ",", " ", 
          RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ","}], "*)"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"(*", 
       RowBox[{
       "\"\<Monodisperse\>\"", ",", " ", 
        "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 1 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ","}], " ",
        "*)"}], 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 20 nm\>\"", ",", "  ", 
       "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"L\",FontSlant->\"Italic\"]]\) = 5 nm & \!\(\*SubscriptBox[\"\
\[Sigma]\", StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 200 nm\>\"", ",", 
       "  ", "\"\<\!\(\*SubscriptBox[\"\[Sigma]\", StyleBox[\"L\",FontSlant->\
\"Italic\"]]\) = 10 nm & \!\(\*SubscriptBox[\"\[Sigma]\", \
StyleBox[\"D\",FontSlant->\"Italic\"]]\) = 500 nm\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopesNoMonodisperse_R250_L10.pdf\>\""}], "}"}], "]"}], 
   ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.904204839229111*^9, 3.9042048718722496`*^9}, {
   3.9042049317555485`*^9, 3.9042049883412623`*^9}, {3.9042050223158765`*^9, 
   3.904205080349517*^9}, {3.9042051298813424`*^9, 3.904205174798168*^9}, {
   3.904205274932716*^9, 3.9042053033232155`*^9}, {3.9042054692436066`*^9, 
   3.9042054695217905`*^9}, {3.9042055522564316`*^9, 
   3.9042055718789825`*^9}, {3.9042061569493556`*^9, 
   3.9042062015067644`*^9}, {3.90420640230344*^9, 3.9042064182799397`*^9}, {
   3.904206461454507*^9, 3.904206473675023*^9}, {3.904206530698953*^9, 
   3.904206546255148*^9}, {3.9042072473100376`*^9, 3.904207247690773*^9}, {
   3.9042074308287063`*^9, 3.904207442761796*^9}, {3.904207475401701*^9, 
   3.9042075090014286`*^9}, {3.90420795653526*^9, 3.904207986680415*^9}, {
   3.9042083571489944`*^9, 3.904208379672203*^9}, {3.904208416223054*^9, 
   3.9042084203195643`*^9}, {3.9042084696313033`*^9, 
   3.9042084864216757`*^9}, {3.9042085730513496`*^9, 3.904208577480511*^9}, {
   3.9042089296643457`*^9, 3.9042089462979665`*^9}, 3.9042090349367676`*^9, 
   3.904209285685599*^9, {3.9042095361642733`*^9, 3.9042095388575706`*^9}, {
   3.9046435971750565`*^9, 3.904643597446463*^9}, 3.9060170095432224`*^9, {
   3.9152691753373613`*^9, 3.915269187041877*^9}, {3.9152715722481318`*^9, 
   3.9152715839816713`*^9}, {3.915271765399427*^9, 3.915271777351932*^9}, {
   3.9152734118539*^9, 3.9152734184602995`*^9}, {3.9174985941691847`*^9, 
   3.917498594800995*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"2c21e791-3c64-4814-add9-6f399d089f54"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3284.088728164614`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 164, 11, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170114977565`*^9, 3.9137864522248793`*^9, 
   3.9152687179561825`*^9, 3.915269189697789*^9, 3.9152716078381667`*^9, 
   3.9152717813421116`*^9, 3.9152734204949803`*^9, 3.917498687452106*^9},
 CellLabel->
  "During evaluation of \
In[164]:=",ExpressionUUID->"c2540ac0-af3c-4d73-ac43-728d4d3674bf"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3283.1661047079383`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 164, 12, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170114977565`*^9, 3.9137864522248793`*^9, 
   3.9152687179561825`*^9, 3.915269189697789*^9, 3.9152716078381667`*^9, 
   3.9152717813421116`*^9, 3.9152734204949803`*^9, 3.9174986874697247`*^9},
 CellLabel->
  "During evaluation of \
In[164]:=",ExpressionUUID->"235334e5-3c69-4672-8e16-f440ec2343b3"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*RowBox[{\\\"Exp\\\", \\\"[\\\", RowBox[{\\\"-\\\", \
\\\"3282.252985264404`\\\"}], \\\"]\\\"}]\\) is too small to represent as a \
normalized machine number; precision may be lost.\"", 2, 164, 13, 
   17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170114977565`*^9, 3.9137864522248793`*^9, 
   3.9152687179561825`*^9, 3.915269189697789*^9, 3.9152716078381667`*^9, 
   3.9152717813421116`*^9, 3.9152734204949803`*^9, 3.9174986874824305`*^9},
 CellLabel->
  "During evaluation of \
In[164]:=",ExpressionUUID->"c2bd2a64-293c-427d-b577-d63a02a0166c"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"General\\\", \
\\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 164, 14, 17125497729078596507, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.904204948875148*^9, 3.9042049761971817`*^9}, {
   3.904205024816019*^9, 3.904205082070112*^9}, {3.9042051381103387`*^9, 
   3.9042051465935926`*^9}, 3.90420517678071*^9, {3.904205290640106*^9, 
   3.904205314180396*^9}, 3.90420547746351*^9, 3.9042055753493023`*^9, 
   3.9042061923525352`*^9, 3.904206222855231*^9, 3.904206547917865*^9, {
   3.9042074857429714`*^9, 3.904207537810108*^9}, 3.9042079876603208`*^9, {
   3.904208359808215*^9, 3.9042083801701365`*^9}, 3.904208424429943*^9, {
   3.904208558671516*^9, 3.904208584082403*^9}, {3.904208758686345*^9, 
   3.9042087876121445`*^9}, 3.90420882358247*^9, {3.9042089420240088`*^9, 
   3.904208946834929*^9}, 3.9042090366878414`*^9, 3.9042092880978737`*^9, 
   3.9042095394408436`*^9, 3.9060170114977565`*^9, 3.9137864522248793`*^9, 
   3.9152687179561825`*^9, 3.915269189697789*^9, 3.9152716078381667`*^9, 
   3.9152717813421116`*^9, 3.9152734204949803`*^9, 3.917498687495697*^9},
 CellLabel->
  "During evaluation of \
In[164]:=",ExpressionUUID->"29959e92-3c66-4e6a-a125-2f4d4c356c48"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lXk4VesXx49zOGZnn4HDESGiIl2lkthCt1KGDJEMJSnRRXKVDCmNSIVM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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw9VXs4VHsbHbdxGzN73I0itzjU0UnIrT2SnEiRQdKhJJci1Omr5FqI4nRI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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9VXk4VXsbPQ6OmW2e5yElKVGm7FOSlMqYMSSlkivTNWRoIEnDFZXkSkRS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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 2.302585092994046}, {-5., 0.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 20 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 5 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 200 nm\"", 
       "\"\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]]\\) = 10 nm & \
\\!\\(\\*SubscriptBox[\\\"\[Sigma]\\\", \
StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]]\\) = 500 nm\""}, "PointLegend",
       DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9042049510971394`*^9, 3.9042049787009907`*^9}, {
   3.90420502689854*^9, 3.904205083630991*^9}, {3.9042051388952513`*^9, 
   3.9042051470596333`*^9}, 3.904205177660756*^9, {3.9042052923319883`*^9, 
   3.904205316284109*^9}, 3.9042054791436996`*^9, 3.9042055765585775`*^9, 
   3.9042061940845275`*^9, 3.904206224603367*^9, 3.9042065490862694`*^9, {
   3.9042074869480314`*^9, 3.9042075389999943`*^9}, 3.904207988879837*^9, {
   3.904208360994763*^9, 3.9042083813900704`*^9}, 3.9042084256362476`*^9, {
   3.9042085598427496`*^9, 3.904208585341796*^9}, {3.9042087598523483`*^9, 
   3.9042087888141003`*^9}, 3.9042088247414417`*^9, {3.9042089431831074`*^9, 
   3.9042089483388777`*^9}, 3.9042090378395414`*^9, 3.9042092892899113`*^9, 
   3.9042095406908007`*^9, 3.9060170129494524`*^9, 3.913786453761344*^9, 
   3.915268720600512*^9, 3.9152691916595154`*^9, 3.9152716095510125`*^9, 
   3.9152717831080685`*^9, 3.9152734223696356`*^9, 3.917498689725362*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"b5b7aaa5-5810-4de8-8b69-1af846ef0afc"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactorsSlopesNoMonodisperse_R250_L10.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.9042049510971394`*^9, 3.9042049787009907`*^9}, {
   3.90420502689854*^9, 3.904205083630991*^9}, {3.9042051388952513`*^9, 
   3.9042051470596333`*^9}, 3.904205177660756*^9, {3.9042052923319883`*^9, 
   3.904205316284109*^9}, 3.9042054791436996`*^9, 3.9042055765585775`*^9, 
   3.9042061940845275`*^9, 3.904206224603367*^9, 3.9042065490862694`*^9, {
   3.9042074869480314`*^9, 3.9042075389999943`*^9}, 3.904207988879837*^9, {
   3.904208360994763*^9, 3.9042083813900704`*^9}, 3.9042084256362476`*^9, {
   3.9042085598427496`*^9, 3.904208585341796*^9}, {3.9042087598523483`*^9, 
   3.9042087888141003`*^9}, 3.9042088247414417`*^9, {3.9042089431831074`*^9, 
   3.9042089483388777`*^9}, 3.9042090378395414`*^9, 3.9042092892899113`*^9, 
   3.9042095406908007`*^9, 3.9060170129494524`*^9, 3.913786453761344*^9, 
   3.915268720600512*^9, 3.9152691916595154`*^9, 3.9152716095510125`*^9, 
   3.9152717831080685`*^9, 3.9152734223696356`*^9, 3.917498690531*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"9f513095-0ad4-4a29-bb94-dab1e1d70d20"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"c4e43655-6657-478b-8231-bb4b9cd4e699"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotFormFactors", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{
        RowBox[{"EstimateMu", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"10", ",", "10"}], "]"}], ",", 
        RowBox[{"EstimateMu", "[", 
         RowBox[{"250", ",", "250"}], "]"}], ",", 
        RowBox[{"EstimateSigma", "[", 
         RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}], ",", " ", 
         RowBox[{"10", "^", "3"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\"\
,FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"[\",FontSlant->\"Italic\"]\)a.u.\!\
\(\*StyleBox[\"]\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
        "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "18"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", "\"\<Monodisperse\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.904192323167556*^9, 3.904192323872614*^9}, {
  3.904192356718018*^9, 3.9041923739657946`*^9}, {3.9152734481650453`*^9, 
  3.915273465516732*^9}, {3.917508315299078*^9, 3.917508315720107*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"d2070e18-38e2-41d7-8cd1-b77426b7a375"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJwtlQs4VPkbx4cYBsOY2xkzbsMMVhfd1NrS+W266L9FLkOhCUu5dBHVquiq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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*StyleBox[\\\"[\\\",FontSlant->\\\"Italic\\\"]\\)a.u.\\!\\(\\*StyleBox[\\\"]\
\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000], 32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 0.}, {-11.512925464970229`, 
      6.907755278982137}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Monodisperse\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    PointSize[0.5], 
                    Thickness[0.09]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"], ",", 
                 RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "True", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9041923275294476`*^9, {3.904192358089244*^9, 3.904192374971711*^9}, 
   3.9041932558611293`*^9, 3.913786455997631*^9, 3.9152687227139387`*^9, 
   3.9152734671308703`*^9, 3.917508317747105*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"8dd3393a-4cea-4932-b8ca-8b05afec1362"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Plot", " ", "monodisperse", " ", "form", " ", "factors", " ", "for", " ", 
    "platelets", " ", "of", " ", "varying", " ", "dimensions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotFormFactors", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "100", ",", "1"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.0001"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "250", ",", "1"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.01"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "100", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "250", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"qlist", ",", 
            RowBox[{"P11", "[", 
             RowBox[{"qlist", ",", "500", ",", "10"}], "]"}]}], "}"}], 
          "\[Transpose]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10000000"}], "}"}]}], "}"}]}]}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "10"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "5"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "100"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "100"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "10"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "250"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "50000"}], "}"}]}], "}"}]}]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
            RowBox[{"EstimateMu", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"10", ",", "1"}], "]"}], ",", 
            RowBox[{"EstimateMu", "[", 
             RowBox[{"250", ",", "250"}], "]"}], ",", 
            RowBox[{"EstimateSigma", "[", 
             RowBox[{"250", ",", "250"}], "]"}]}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}]}], "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["10", 
            RowBox[{"-", "14"}]], ",", " ", 
           SuperscriptBox["10", "8"]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks3", "[", "True", "]"}], "[", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "14"}]], ",", " ", 
             SuperscriptBox["10", "8"]}], "]"}], ",", 
           RowBox[{"PowerTicks2", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"P\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"[\",FontSlant->\"Italic\"]\)a.u.\!\
\(\*StyleBox[\"]\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 1000 nm\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<FormFactors_Monodisperse_Dimensions.pdf\>\""}], "}"}], "]"}], 
     ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotFormFactors", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9071451998238287`*^9, 3.9071452218936872`*^9}, {
   3.9071452551883564`*^9, 3.907145327526991*^9}, 3.9071453722031226`*^9, {
   3.9071454918743134`*^9, 3.9071455450343275`*^9}, {3.90714639775727*^9, 
   3.9071464139416103`*^9}, {3.9071466349379673`*^9, 3.9071466425181985`*^9}, 
   3.9137867264264603`*^9, {3.913787308213293*^9, 3.91378730861329*^9}, 
   3.913790009504179*^9, {3.913790122172845*^9, 3.9137901243936667`*^9}, {
   3.913790154536107*^9, 3.91379015613441*^9}, 3.9137904057708516`*^9, {
   3.9152692875293837`*^9, 3.915269293049816*^9}, {3.9152694039042125`*^9, 
   3.9152694617055826`*^9}, {3.9152695795294333`*^9, 3.915269586335517*^9}, {
   3.9152696756490917`*^9, 3.915269756403026*^9}, {3.9152699014143248`*^9, 
   3.9152699435219965`*^9}, {3.915270201984589*^9, 3.915270213332224*^9}, {
   3.91527024448698*^9, 3.9152702854995365`*^9}, {3.9152704533036504`*^9, 
   3.915270457699065*^9}, {3.915270492108449*^9, 3.915270502937126*^9}, {
   3.917508326887246*^9, 3.9175083276208553`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"0e7a69cc-0930-409f-9504-ded371638160"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lgtYTHkfx6diulBqmppmus2cabrqMtNUUpwWSbJuqSiVtdbSBbEivbai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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lgk4VHsfx4W0Wc+MGbMxY4wwdhl1w1FSud23qO61JXFLe3SFthuVFlta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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lglYjWkbx895O9pPnZbT2dpOmxZaJGToeYgipShKUSENQzOSBmMrpcxn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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lgtYTOkfx6cp1XTRTDPT3GqaOTV0IbuIhN53hVy6KLpQKlMhiq2E2MRq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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lgk8lPkfx8eQpDCXOR1zmHEMZiodsvX7dW2HpFIhcnWoVJTtoNrU6tC1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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -32.23619130191657}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"P\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*StyleBox[\\\"[\\\",FontSlant->\\\"Italic\\\"]\\)a.u.\\!\\(\\*StyleBox[\\\"]\
\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "14"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000], \
-322.3619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000], \
-315.45415774018426`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000], \
-308.54640246120215`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000], \
-301.63864718222], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000], \
-287.8231366242557], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000], \
-274.00762606629144`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000], -260.19211550832716`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000], -246.3766049503629], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000], -232.56109439239862`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000], -218.74558383443434`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000], -204.93007327647007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000], -191.1145627185058], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000], -177.29905216054152`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000], -163.48354160257725`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
], -149.66803104461297`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000], \
-135.8525204866487], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000], \
-122.03700992868443`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000], \
-108.22149937072015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000], -94.40598881275588], 
          
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000], -80.5904782547916], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000], -66.77496769682732], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000], -52.95945713886305], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000], -39.14394658089878], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000], 29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000], 43.74911676688687], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000], 57.564627324851145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000], 71.38013788281542], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000], 85.19564844077969], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000], 
           99.01115899874397], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000], 
           112.82666955670824`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000], 
           126.64218011467251`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000], 
           140.4576906726368], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000000],
            147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0], 154.27320123060107`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000], 161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000], 168.08871178856535`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000], 174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000000], 181.90422234652962`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000000], -31.543044121356694`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 3]], -31.13757901324853], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000000], -30.84989694079675], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000000], -30.626753389482538`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000000, 3]], -30.444431832688583`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 7]], -30.290281152861326`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000000], -30.156749760236803`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 9]], -30.03896672458042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000], \
-322.3619130191664], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000000000000000], \
-317.7567428331783], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000000000], \
-313.1515726471902], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000], \
-308.54640246120215`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000000000], \
-303.941232275214], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000], \
-299.33606208922595`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000], \
-290.12572171724975`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000], \
-285.5205515312617], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000], -276.3102111592855],
           ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000], -271.7050409732974], 
          ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000], -262.4947006013212], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000], -257.8895304153331], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000], -248.67919004335693`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000], -244.07401985736885`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000], -234.86367948539265`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000], -230.25850929940458`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000], -221.04816892742838`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000], -216.4429987414403], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000], -207.2326583694641], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000], -202.62748818347603`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000], -193.41714781149983`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000000000], -188.81197762551176`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000000000], -179.60163725353556`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000000000], -174.99646706754748`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0000000], -165.78612669557128`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
00000], -161.1809565095832], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
0], -151.970616137607], ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000000000]\
, -147.36544595161894`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], ""}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000000000], \
-138.15510557964274`], ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000000000], \
-133.54993539365464`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], ""}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000000000], \
-124.33959502167846`], ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000000000], \
-119.73442483569038`], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], ""}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000000000], \
-110.52408446371419`], ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000000000], \
-105.9189142777261], ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], ""}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000000000], -96.70857390574992],
           ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000000000], -92.10340371976183], 
          ""}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          ""}, {
          
          NCache[-Log[
            1000000000000000000000000000000000000], -82.89306334778564], ""}, {
          
          NCache[-Log[
            10000000000000000000000000000000000], -78.28789316179756], ""}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947],
           ""}, {
          NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
          ""}, {
          NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
          ""}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], ""}, {
          NCache[-Log[1000000000000000000000000], -55.262042231857095`], ""}, {
          NCache[-Log[10000000000000000000000], -50.65687204586901], ""}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], ""}, {
          NCache[-Log[1000000000000000000], -41.44653167389282], ""}, {
          NCache[-Log[10000000000000000], -36.841361487904734`], ""}, {
          NCache[-Log[100000000000000], -32.23619130191664], ""}, {
          NCache[-Log[1000000000000], -27.631021115928547`], ""}, {
          NCache[-Log[10000000000], -23.025850929940457`], ""}, {
          NCache[-Log[100000000], -18.420680743952367`], ""}, {
          NCache[-Log[1000000], -13.815510557964274`], ""}, {
          NCache[-Log[10000], -9.210340371976184], ""}, {
          NCache[-Log[100], -4.605170185988092], ""}, {0, ""}, {
          NCache[
           Log[100], 4.605170185988092], ""}, {
          NCache[
           Log[10000], 9.210340371976184], ""}, {
          NCache[
           Log[1000000], 13.815510557964274`], ""}, {
          NCache[
           Log[100000000], 18.420680743952367`], ""}, {
          NCache[
           Log[10000000000], 23.025850929940457`], ""}, {
          NCache[
           Log[1000000000000], 27.631021115928547`], ""}, {
          NCache[
           Log[100000000000000], 32.23619130191664], ""}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], ""}, {
          NCache[
           Log[1000000000000000000], 41.44653167389282], ""}, {
          NCache[
           Log[100000000000000000000], 46.051701859880914`], ""}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], ""}, {
          NCache[
           Log[1000000000000000000000000], 55.262042231857095`], ""}, {
          NCache[
           Log[100000000000000000000000000], 59.86721241784519], ""}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], ""}, {
          NCache[
           Log[1000000000000000000000000000000], 69.07755278982137], ""}, {
          NCache[
           Log[100000000000000000000000000000000], 73.68272297580947], ""}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], ""}, {
          NCache[
           Log[1000000000000000000000000000000000000], 82.89306334778564], 
          ""}, {
          NCache[
           Log[100000000000000000000000000000000000000], 87.49823353377374], 
          ""}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183],
           ""}, {
          NCache[
           Log[1000000000000000000000000000000000000000000], 
           96.70857390574992], ""}, {
          NCache[
           Log[100000000000000000000000000000000000000000000], 
           101.31374409173802`], ""}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], ""}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000], 
           110.52408446371419`], ""}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000], 
           115.12925464970229`], ""}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], ""}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000], 
           124.33959502167846`], ""}, {
          NCache[
           Log[100000000000000000000000000000000000000000000000000000000], 
           128.94476520766656`], ""}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], ""}, {
          NCache[
           Log[1000000000000000000000000000000000000000000000000000000000000],
            138.15510557964274`], ""}, {
          NCache[
           Log[
           100000000000000000000000000000000000000000000000000000000000000], 
           142.76027576563084`], ""}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000000],
            147.36544595161894`], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
], 151.970616137607], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
00], 156.5757863235951], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000], 161.1809565095832], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
000000], 165.78612669557128`], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
00000000], 170.39129688155938`], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000], 174.99646706754748`], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
000000000000], 179.60163725353556`], ""}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
00000000000000], 184.20680743952366`], ""}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000000], -31.543044121356694`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 3]], -31.13757901324853], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000000], -30.84989694079675], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000000], -30.626753389482538`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000000, 3]], -30.444431832688583`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 7]], -30.290281152861326`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000000], -30.156749760236803`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 9]], -30.03896672458042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-32.23619130191664, 18.420680743952367`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 1000 nm\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9137901934369364`*^9, 3.9137904489710565`*^9, 
  3.915268776142004*^9, 3.915269347584866*^9, 3.9152695224575996`*^9, 
  3.9152697989668865`*^9, 3.9152699462063723`*^9, 3.9152700087417717`*^9, 
  3.915270258213597*^9, 3.9152703410163326`*^9, 3.9152706722620883`*^9, 
  3.917508370772128*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"2bc342ef-5970-402f-9685-e2bc272e6324"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactors_Monodisperse_Dimensions.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.9137901934369364`*^9, 3.9137904489710565`*^9, 
  3.915268776142004*^9, 3.915269347584866*^9, 3.9152695224575996`*^9, 
  3.9152697989668865`*^9, 3.9152699462063723`*^9, 3.9152700087417717`*^9, 
  3.915270258213597*^9, 3.9152703410163326`*^9, 3.9152706722620883`*^9, 
  3.917508374187008*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"cf706023-c64a-4d00-a34a-1d9ee6a77986"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Fixed", " ", "polydispersity", " ", "of", " ", "50", "%", " ", "in", " ",
      "all", " ", "dimensions"}], ",", " ", 
    RowBox[{"varying", " ", "sizes"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotFormFactors", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"100", ",", "50"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"100", ",", "50"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.0001"}], "}"}]}], "}"}]}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"1", ",", ".5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "125"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "125"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.01"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"100", ",", "50"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"100", ",", "50"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"250", ",", "125"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"250", ",", "125"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"EstimateMu", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"10", ",", "5"}], "]"}], ",", 
           RowBox[{"EstimateMu", "[", 
            RowBox[{"500", ",", "250"}], "]"}], ",", 
           RowBox[{"EstimateSigma", "[", 
            RowBox[{"500", ",", "250"}], "]"}]}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000000"}], "}"}]}], "}"}]}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["10", 
            RowBox[{"-", "14"}]], ",", " ", 
           SuperscriptBox["10", "8"]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks3", "[", "True", "]"}], "[", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "14"}]], ",", " ", 
             SuperscriptBox["10", "8"]}], "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"I\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"[\",FontSlant->\"Italic\"]\)a.u.\!\
\(\*StyleBox[\"]\",FontSlant->\"Italic\"]\)\>\"", ",", " ", "None"}], "}"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"PlotStyle", "->", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
             "Automatic"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
            "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", 
           ",", " ", 
           RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", 
           " ", 
           RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", " ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", "  ", 
         "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 1000 nm\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", "Black", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<FormFactors_Polydisperse_Dimensions.pdf\>\""}], "}"}], "]"}], 
     ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotFormFactors", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.90714565731478*^9, 3.907145811265035*^9}, {
   3.9071465345815744`*^9, 3.907146614985768*^9}, {3.9137873191121883`*^9, 
   3.913787341135173*^9}, 3.9137873982572913`*^9, {3.9137904149489727`*^9, 
   3.913790424499771*^9}, 3.91527037740199*^9, {3.915270646922429*^9, 
   3.915270731999933*^9}, {3.915270764259286*^9, 3.915270767465353*^9}, {
   3.9152719096397524`*^9, 3.915271910611332*^9}, {3.9175083833687115`*^9, 
   3.91750838438211*^9}},
 CellLabel->
  "In[175]:=",ExpressionUUID->"9f706ecb-10fe-4604-b12c-bc20d76b379b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1lglYTPsfxqddJWqamqX9zNK0aWraw+naSlm6KqGryFoiSZQ1XZFykyWK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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lglUE+cahgNoECUSspKFQAgh7PteYaJo646KFRQVpLhUqIItV1GsQKl1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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw1lgs4VOkfx2eGMBiXMYwZ1zHIXS5TLHpPa0tRKSrdsNGF6KKl1pKIyqZd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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw1lglYjNsfx6fFpJrRzDT71EzTJpkohO6Vc1KXhDZSkiJrtkp/15q4qatL
spSKpFz/hJu1rovc8xOFZKdNkQotSEkalf7+7zszzzPPPO/zzjnv73yXz4wy
PNJ/qS6Dwbj74/3/z5zBlMw/cmVQAmlHGHNleGGQ/erwdTK4sv7SXoGPDFtc
uDX5J3cZBBTYZOybJsOvDMO4PL4M5nhOu7YUyfCxcHVTa7MUlOYLPHaNl+Gw
awf/vlEkBXdWV2mbSoYV/FFJmYlSeNsaI4qzlOGXq+/Mjw6Uwtw9KGC8SIaz
S8NHTbeTQpjtjEaGsQyHygcYSrUEut2yVz0YkGL5hvSnvXclILct+5DcIcX1
D53yHh2WQP2I/xQ7NEjxUbuKjfmrJFAcEb3nyEMpDt2xbMb2SRKAJM72W9el
2LyWIQ9iSyA0f8r4tNM/1o858mn0SzGciYmqU6f9WL/b+abBOTGExY51fxkn
xQuaH6a9ihPDpARmj8OKH+tdV6647CuGrsSBgGfeUlyXpv9zilIMrE8pl4vH
SnHWx2z28i4RXNqyMf6JUIpDprk0TL4pgvclecE6vRJslvP0ojBVBA6bx7s6
V0nwi941CR+XiGDc2sDC4EIJPuI3NKjMWQQ1QQaDoSkSPP/0cftspgiOusW4
Oa6QYJme68D6KiF8aLzz9/XJElw7v+rhrHwhcNWOb77yJPhwYfRxm01CCGnM
ePqoWYyD2az1A9OF4KN+gScVirF0Wd6051Ih+H8reTF6hxjX/IulBe0C6BU7
bflzhhhnil6831ksgEUPLgbsNxXjeVHrSUiyABqqN03oqRZh8V2TA+NCBTCG
nCh6fESEq5Wnl7BGC+D7yrgFtiEinLnZY0LzIB8W1U14qZaIcNDTl4bFj/gQ
7es7MuC5EEtUm+oO5vLBJKg9zWOvEFftND23ah0f7CPaa6s8hDijvmCHuzsf
FKUVVpZqAQ4c7zlHxucDJ8Gm1+WMAItTGm0/N5tCqGuduct8Aa56t1VdXmQK
+Fn0skmGApyORRXHE02hLcN5xeIiPg7MvJC9OdAUBna/s3wUxseirhnR/nam
sMhFtS9vKB9Xer11t1fzQPXeTck6b4oP/bldqFvOg6ufD6qGzzXFc/ulrTWH
ebAR6/rI+3hYEFB07cIqHlgavioVHePh5wU+e5Mm8YAU5d6eOIWH05htCxex
eWB4tf/1iWYuDgjbOdblJRcKrX9ZEpvIxfx/5EzuOS4cSKiuaxjOxc84V6pb
4rhguDvsXNsdDk6NmH0GfLmwtnrjnYsRHDyn5ENshpIL5nUZ0bOMOJgv2+Ub
1cUB1vrHuw8FmOBnMZZWnjc58HvmpeR1h4bhgxXFXxSpHMhqWCydUsXGs20C
73xdwoH06ZFWPDEbm27rPPzQmQPranVM2oJY+Gnl7jUnmRw4537it4pMY2wT
NnP797MmYH2rbfw/tUb4BGeHzVlfE3ha1nw7X2aErUuKyhd0DYM/Jr7fkB5i
iP+MaYtkpw6D4OYHdVuODsVWNgrBdedhALdbome+NMDHK2dfXV3FhqNnQlmD
cgNsuWtXmNkmNrCN9ZySwpj4uMt1/QopG7riFs9qODYEW7Z3ntpSzIJxCz5X
ql/p49wsW5+RoSywcvhpzj2FPlZ6z++uHTSG1kOL5niF6WGaV8bQ15w4b3W2
roZPxlAW0HLFtl5HwyMjWOYXt2WtTEfDHyNYca9DNXEeQ8MbI4gmOls7VIOI
5oshRCzyuojzBhDNE0PQ2z0Y6ynvR2YUPwzBPDjfszX1G8qieDEUtnU3WesZ
qRHNh6FwnVV9MCb2K6J5YAATD+/zFnR8QXT/DaChYT8PQrsR3XcDyGG1RnlW
dCG630wIWjfyWNyETkT3mQnNhsNSl+EORPeXCQcGtz0JZr1HdF+HQE7vPPsV
T1qQhOrnEHheY1zMO/AGZVB91IdHUOtV6dWIRFT/9OFCa3r7jN56lE71TR9G
MU51VHlVIbpfemC4jdvI2/MI0X3SAxOPrLag9TcR3R89+O12chzrdB6i+6IL
AhbPJ+XQeUL3QxcOZwTPlESWEboPuhDa/jqTH/6ECKj868CptyMftebVEDrv
OpDseMX+bXwDMaXyzYD9U/0Lp7o3EzrPDCBTVB6/81oInV8GLNbtU+R0tRNr
Kq+DJGx7eOC+5g5iReXzO/mJuzPqbHcnUVJ5/E5yEv8qM9DpJhZU/gbIngL/
N7WiHmJB5a2fzAY4fM6llyiofPUReeCtr+zl34g5lac+sk5cERyb00/Mqfx8
I5d2Fs2Nf/udyKi8qMnjvdMmPs5igILKh5oY3FweqLqvA3IqD71kJ69avVdf
D8wp/7+SNQ4lbKcfuptRfveQ8IaUVb8kDQEZ5W8P6fz1dVZvJROklJ9fSLG6
YWOkaiiIKf+6ic3cwv2lSYZA+/WZDI+MjDTuMALan89kkfPEQx4hLKD96CIb
w3IClz5mA82fTjLIeb/O19sEaL0/kVc1JVNXRnCAR+n7iTirQsrnjOYCredH
0rjVkXe5lwtKSr8PpHZpe7J/KQ/klF7txM/R535NqimYUfq0kXjJzOqOZXyQ
Unq0kkbOHhO7nwUgps7/jpzg95UzuUIQUed9Sz741X3QbRGCKXW+ZrLPryJ3
FxEBjzpPE+EutA0aOCQGDjX/a/JBZyK3dI0E2NS8DSQuov6qp7sUJNR89aRf
MddtQCgDG2qeWmIV5Ht5ZYsMLKjnV5GrJjOfjrlsBmbU854R8uZ1jyDeHKTU
/o/JlYQN3J4ZcrCj9rtPFFfKuiq5CrCk1t8mCez6gRfPFCCivn+D9C1vKsv1
sgAr6v5lEszODzh/ygJsqOuThHthVcddAyUwNK/Qk7/2KJcqwZa+j37Wc05v
v6EEJb0ebTrYxAiUW2r3RwHfp8xK2Wyp2f82uhbfobhSaQkj6flQk513V+cY
K+386FXK/G6fFCswp8+Htjf4L2lst9KeH/XyUl0velpr9UGFn0osbv7XGkbQ
+qEWt7XBfD0bENH6Ite7f3fmLrQBCa0/mqyq/mvpvzYgo/1B5V9rBgLNbEFO
+4eq+C33ozbbgoL2F8Xeu6fMr7bV6PcOSS5mp/WMHw4SOh/ofETf+YC04dr8
II5nvAg+Dwe6j+3oHEQdcfK30+YPecvYLifP24ElnU9kUjhZV2EyAmg+fEI3
F4t0MtaM0OYb5bvEiHgVI7T5R0OO7mhItrcHId0PFDzvTDoryV7bH6T7pYq5
7529tl9Itb94q3TqSKD/v3SjlecLy8+eGKntJ3rbVOTpq6fS9hfF3net1w3/
cU33G32syWPeA5W2/wi2mDQVKBy0fEDWM7+OvbDNQcsPNObak+AX9Q5gQfMF
eU+XzRzrOgqUNH+Qr+DBr5A1CixpPqEN9o+z/+gfBVY0vxBcDz2VGTIarGm+
oUj57PlfikeDDc0/dKt0SMKTYY5gS/MRxWx2yglEjho9v6MjuYoCVpQjaPiK
4kP1kj/nOGr4wMCZN8Ry9hNH0PAZsxu/MefpOQH9/4SBZ61fkPh8nBNo+I45
TDevuGVOGv11sN3vtX5+GU6g+X3AIF1Q71HupPFDF7sn7V/r1+8E/wM5r+ya

         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw1lgs4lGkbx8c5h2HOZ8aMGWZG2XRaPtXzFB1VOq2Idai2XQnRaisR1lql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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.907755278982122, -32.23619130191657}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"I\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\)\\!\\(\\*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\
\\*StyleBox[\\\"[\\\",FontSlant->\\\"Italic\\\"]\\)a.u.\\!\\(\\*StyleBox[\\\"]\
\\\",FontSlant->\\\"Italic\\\"]\\)\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> {
       GrayLevel[0]}, FrameTicks -> {{{{
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "14"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           
           TemplateBox[{"10", "7"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000], \
-322.3619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000], \
-315.45415774018426`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000], \
-308.54640246120215`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000], \
-301.63864718222], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000], \
-294.7308919032379], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000], \
-287.8231366242557], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000], \
-280.9153813452736], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000], \
-274.00762606629144`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000], -267.09987078730927`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000], -260.19211550832716`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000], -253.28436022934503`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000], -246.3766049503629], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000], -239.46884967138075`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000], -232.56109439239862`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000], -225.65333911341648`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000], -218.74558383443434`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000], -211.8378285554522], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000], -204.93007327647007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000], -198.02231799748793`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000000], -191.1145627185058], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000000], -184.20680743952366`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000000], -177.29905216054152`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000000], -170.39129688155938`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000000], -163.48354160257725`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
000], -156.5757863235951], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000000\
], -149.66803104461297`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000000], \
-142.76027576563084`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000000], \
-135.8525204866487], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000000], \
-128.94476520766656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000000], \
-122.03700992868443`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000000], \
-115.12925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000000], \
-108.22149937072015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000000], \
-101.31374409173802`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000000], -94.40598881275588], 
          
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000000], -87.49823353377374], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          
          NCache[-Log[
            100000000000000000000000000000000000], -80.5904782547916], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000000], -73.68272297580947], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000000], -66.77496769682732], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000000], -59.86721241784519], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000000], -52.95945713886305], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000000], -46.051701859880914`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000000], -39.14394658089878], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000], 23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000], 29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000], 36.841361487904734`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000], 43.74911676688687], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000], 50.65687204586901], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000], 57.564627324851145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000], 64.47238260383328], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000], 71.38013788281542], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000], 78.28789316179756], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000], 85.19564844077969], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000], 92.10340371976183], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000], 
           99.01115899874397], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000], 
           105.9189142777261], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000], 
           112.82666955670824`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000], 
           119.73442483569038`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000], 
           126.64218011467251`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000000000000000000000000000000000000000000000000000000], 
           133.54993539365464`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000], 
           140.4576906726368], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           10000000000000000000000000000000000000000000000000000000000000000],
            147.36544595161894`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0], 154.27320123060107`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000], 161.1809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000], 168.08871178856535`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000], 174.99646706754748`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[
           1000000000000000000000000000000000000000000000000000000000000000000\
0000000000000], 181.90422234652962`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000000], -31.543044121356694`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 3]], -31.13757901324853], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000000], -30.84989694079675], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000000], -30.626753389482538`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000000, 3]], -30.444431832688583`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 7]], -30.290281152861326`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000000], -30.156749760236803`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 9]], -30.03896672458042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000000000000], -32.23619130191664], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000000], -31.543044121356694`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 3]], -31.13757901324853], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000000], -30.84989694079675], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000000], -30.626753389482538`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000000, 3]], -30.444431832688583`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 7]], -30.290281152861326`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000000], -30.156749760236803`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000000, 9]], -30.03896672458042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000000], -29.933606208922594`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000000], -29.240459028362647`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 3]], -28.834993920254483`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000000], -28.547311847802703`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000000], -28.324168296488494`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000000, 3]], -28.14184673969454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 7]], -27.98769605986728], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000000], -27.85416466724276], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000000, 9]], -27.736381631586376`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000000], -27.631021115928547`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000000], -26.937873935368604`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 3]], -26.53240882726044], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000000], -26.244726754808656`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000000], -26.021583203494448`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000000, 3]], -25.839261646700493`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 7]], -25.685110966873236`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000000], -25.551579574248713`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000000, 9]], -25.43379653859233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000000], -25.328436022934504`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000000], -24.635288842374557`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 3]], -24.229823734266393`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000000], -23.942141661814613`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000000], -23.7189981105004], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000000, 3]], -23.536676553706446`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 7]], -23.38252587387919], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000000], -23.248994481254666`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000000, 9]], -23.131211445598282`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000000], -23.025850929940457`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000000], -22.33270374938051], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 3]], -21.927238641272346`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000000], -21.639556568820566`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000000], -21.416413017506358`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000000, 3]], -21.234091460712403`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 7]], -21.079940780885142`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000000], -20.94640938826062], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000000, 9]], -20.82862635260424], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000000], -20.72326583694641], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000000], -20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 3]], -19.624653548278303`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000000], -19.33697147582652], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000000], -19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000000, 3]], -18.931506367718356`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 7]], -18.7773556878911], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000000], -18.643824295266576`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000000, 9]], -18.526041259610192`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000000], -18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000000], -17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 3]], -17.322068455284256`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000000], -17.034386382832476`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000000], -16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000000, 3]], -16.62892127472431], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 7]], -16.474770594897052`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500000], -16.34123920227253], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000000, 9]], -16.223456166616145`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000000], -16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000000], -15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 3]], -15.01948336229021], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500000], -14.73180128983843], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000000], -14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000000, 3]], -14.326336181730264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 7]], -14.172185501903007`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250000], -14.038654109278484`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000000, 9]], -13.9208710736221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000000], -13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500000], -13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 3]], -12.716898269296165`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250000], -12.429216196844383`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200000], -12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500000, 3]], -12.02375108873622], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 7]], -11.86960040890896], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125000], -11.736069016284437`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000000, 9]], -11.618285980628055`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000000], 13.815510557964274`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000000], 14.508657738524219`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000000], 14.914122846632385`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000000], 15.201804919084164`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000000], 15.424948470398375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000000], 15.60727002719233], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000000], 15.761420707019587`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000000], 15.89495209964411], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000000], 16.012735135300492`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000000], 16.11809565095832], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000000], 16.811242831518264`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000000], 17.216707939626428`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000000], 17.50439001207821], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000000], 17.72753356339242], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000000], 17.909855120186375`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000000], 18.064005800013632`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000000], 18.197537192638155`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000000], 18.31532022829454], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000000], 18.420680743952367`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000000], 19.11382792451231], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000000], 19.519293032620475`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000000], 19.806975105072254`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000000], 20.030118656386467`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000000], 20.21244021318042], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000000], 20.36659089300768], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000000], 20.5001222856322], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000000], 20.617905321288585`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
      2.302585092994046}, {-32.23619130191664, 18.420680743952367`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 1000 nm\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9071458269152193`*^9, {3.907146566444562*^9, 3.907146617490886*^9}, 
   3.913786511971122*^9, {3.9137873789096594`*^9, 3.9137874012023125`*^9}, 
   3.913790475329361*^9, 3.9152687839643984`*^9, 3.915270382607953*^9, 
   3.915270735723888*^9, 3.915270772297663*^9, 3.9152719172200356`*^9, 
   3.9175083878941565`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"d352ddd2-f7a4-458a-9146-f916ccfb56c6"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactors_Polydisperse_Dimensions.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.9071458269152193`*^9, {3.907146566444562*^9, 3.907146617490886*^9}, 
   3.913786511971122*^9, {3.9137873789096594`*^9, 3.9137874012023125`*^9}, 
   3.913790475329361*^9, 3.9152687839643984`*^9, 3.915270382607953*^9, 
   3.915270735723888*^9, 3.915270772297663*^9, 3.9152719172200356`*^9, 
   3.91750839098322*^9},
 CellLabel->
  "Out[176]=",ExpressionUUID->"a3ecd714-da69-4334-bc23-babcf05f87b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotSlopes", " ", "=", " ", 
  RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"100", ",", "50"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"100", ",", "50"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Shift", " ", "in", " ", "y", " ", "direction"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"1", ",", ".5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "125"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "125"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"100", ",", "50"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"100", ",", "50"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"250", ",", "125"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"250", ",", "125"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"slope", "[", 
        RowBox[{"calculateIntensitiesLR", "[", 
         RowBox[{
          RowBox[{"EstimateMu", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"10", ",", "5"}], "]"}], ",", 
          RowBox[{"EstimateMu", "[", 
           RowBox[{"500", ",", "250"}], "]"}], ",", 
          RowBox[{"EstimateSigma", "[", 
           RowBox[{"500", ",", "250"}], "]"}]}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", " ", 
         RowBox[{"10", "^", "1"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"10", "^", 
        RowBox[{"-", "10"}]}], ",", 
       RowBox[{"10", "^", "4"}]}], "}"}], " ", "*)"}], "\[IndentingNewLine]", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
         "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}], ","}], "*)"}], 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", " ", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic"}], 
          "}"}]}], "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "1", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic", ",",
          " ", 
         RowBox[{"Opacity", "[", "0.6", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "9", "]"}], "[", "2", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Automatic", ",", " ", 
         RowBox[{"Opacity", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", " ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 1 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", " ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 200 nm\>\"", ",", "  ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 500 nm\>\"", ",", "  ", 
       "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) = 10 nm, \
\!\(\*StyleBox[\"D\",FontSlant->\"Italic\"]\) = 1000 nm\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<FormFactorsSlopes_Polydisperse_Dimensions.pdf\>\""}], "}"}], "]"}],
    ",", 
   RowBox[{"Show", "[", 
    RowBox[{"plotSlopes", ",", " ", 
     RowBox[{"ImageSize", " ", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", " ", "cm"}], ",", " ", 
        RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9071458530672703`*^9, 3.9071459604259977`*^9}, {
  3.9071459913173695`*^9, 3.9071459987269588`*^9}, {3.907146067717845*^9, 
  3.9071460952455072`*^9}, {3.9152708051668997`*^9, 3.915270816139504*^9}, {
  3.917498609547869*^9, 3.9174986102539873`*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"6b2ad393-929f-4b47-9b88-84035511f772"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[1]], 
        LineBox[CompressedData["
1:eJw1VXk4VV8bPfea53vNLpmVEKVUio5SSkUyJz8yJMRHUWalFCIlpCSZ0yCZ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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.8]], 
        LineBox[CompressedData["
1:eJw1lXk4lN8bxt8ZY99mxjIMDZIt1fQlitKrVFolS4lCUtFGpKxZkmxtElkq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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.6]], 
        LineBox[CompressedData["
1:eJw9lnk4VWsbxvdg2qa9tmmzUVQkNCkisVDJ8JExkkNJUuqoNBgzphKnTMmQ
JCEVEaHwPlSSCBkzZc6JkyFzhm9/1/qcP9a1rue61/Cu57nv37tkndwtTlBI
JFIV+/jfmaTcFTRzUxK2hB9MzVBOQBByxfqznSRolLf7BaYnoYAuhkK6kiR8
CzYmCR55gHC1Zwt+iyyQO3XnLtr4EK38pV9rXcsCalzmo6J3qQh973mwOZkF
BR8KEjyvp6GrOj4XON1ZYHs084KuRzrSjhfd34WzICJ9vib6ViZanshhFmAs
0Asp41BpykJlRkY/wnsloOfiuNh68+fo6qOBEuc8CVA2MnliR32BtBav3t4T
LAGO++McwDcXLVtJOIlYScDAyPGwncyXqOz5y52jGyTA7mTz04PN+ciPy5T7
3bQ4CKWO2zUUv0JajsNfEyvF4ad97cmUD0VoqTDomUecONx+4XWnmvwGlWLS
/sau4pBGEi4NditFvqcKzddriMP6lABbIQ5AeyrMN/ymibP7tXg75mw5WmSN
znxpZ4KUd2mY2FQFKvEI/Zj1lAneYiufL8a/Q741MklBvkzgi5gwu+dYiTTl
3vxpZ8KEnYstEx4GVei3n7Wuyhom1OzwCiMfqkZvWsaEecfEINGk20c7rAZ5
bw0b6kVicO54ZMXG75/R7hsbiovviMEnfa33doX1aKGn7FbkMTGY9gqTdWN8
Qa81DjucUhGDOL2BhPygRuQd9WubLlUMhsqlzKX4m5HGSARVokkURBR2v/TK
bkHzexVaxtNEQfHUReno022oKKkis+qSKETxM/RZuu3Ic9reJ0VfFCS3kPwz
VTqRuumsiSdTFOZzZ7+8xrvRXHqkjNmwCKzTqqLY7OxBRStKvzYWi8Azv4N4
16Fe5Glb+X7lpgjkRLaIeF7vQ+q5R++12onAu+yYTRKV/WiO9vt0jpIIhGN1
lfFCg6jIKVbr+qIw7MgUbS46M4Q832zFHGuFwfbIwWHxpu9ol0h1n1qyMGxL
CnbSNvgbzZ5xLhB0F4ZDtYYFEVU/UOH75etDuDD4l/N9MrQaRZfXxNuVYcLQ
dnUgNerHP0jtyo7Nd3uFQDGoV8k5bAzN1NWunM0TAhXvk4VG8ePolYLrl/3B
QmAZpsU/em4CXQqkPJa2EgIN5eI99saTSLU96cr0BiHoe1ZGq9v4C02r7DKq
nWaARNUuVxfOKZR/q0HqcSUD1MNdAnb0T6GLA25jvnEMoBaFyqrDNNqpxVVh
5cqATucHr10TZ9BUbEqMsgYDunrGh7M9ZlH+z90nOXgZ4O59P2v0wBy6eKBZ
o7MdA8mlZB0Scx7tTHHnz3+KQcRel/dV3+bRrznat1u+GDwrs7ik9HABvTRP
yz1ugsFc/aFECbvfyCNLO0RzDQZnxnO44miLyIUr77l8Nx1iXnN+g+xFNFA4
ZNHiT4cdHe6JTQZLyPmU5Nw1WTp0BWnUq7UuoQGW2X3Vt4Kg//6xp9fhZXS8
JkRv0FkQRI0+2hyrW0Z9fsXfY7gEQTVCjeeH+gpy2vozfF+mANTb/7IxuLuC
+nrWqUwZCkAAOSD5x3e2HmXT+miEHzQLVk5rMknQtzfc1zKCH84JfFY5rkqC
Y9MgS93KD6bX4jvGTEnQkz5dmVfPB9c+WY9fdibBUVvFM04X+GCG2+F04mW2
TnNkCInwgRurwpYnlASOb6JflRfwAtNP94xbNAm6z1QdOW/DC/vwYeT+gAQO
a5ZIsvM0uBKas7U4i63XbU+vT6DBnUHOgJ4CEtgHuhgH7KGBaGh+yLlyEnSq
JI5v7eaBps7hPwZq2fpAXew3fx4wjFKrTu9g67EcmrdleUDgTv9loRG2fkCj
R/stN6xTb5f3WGTrc2ev/XTmBnvaeT9ujAxHslIVk7m4oUtXUZUqT4b2I611
JplcsGlG+VakNhnsBPgvLRlywecR7+eth9l6mQ7r+QgntHaepcxeIcPhc5eQ
fQQnLNGPKdLjydAmm+XMv5UTMiR1M/BSMtg2dtNK6jlAMWpi7ZMBMrSGCOe4
XeCASFc97T/pFLBVM7CSFOGA0RbhzflaFGj77jtfXUCFygBmeao7BWzic5O9
baiwHXM97PyYAi1GQ3sV5ynwtXJbqNw3ChxaZP39NYEC+gabg0WkqdD8/OBf
N/dQoHqzcdRRRypYO4bs0Ogmw8zm2zoa6VRoworbhv3J0N0+lFQ7QQWrin/8
7smSISZQ0MVYjwMaPdatN3hLAieXIyrdcRxgKWdTNcuec7aXclT2JAd8abl1
NoOLBIfM+ZR7LTghDQuUyzZbQaPX19XHFnFCqscPd4GYZSRbHek/tJ4LUlos
X59h+3bfoM7xoRh2rVHKUcNaQqPi9OcpfNyQkiR/UMlhEWVLh/3BvMENySu3
48Me/kZLH5591+XlgftO8/1/DyygyCu+T/mieCDpvdMWQ4UFdJWvBLdYS4P7
CjWemW7zqBtzCerPpUHyLdW33DlzyDrS5qSPIS8k/0wWODk5iwZp4Fs+yAtJ
5jy2laqzqGN7m7R+KB8k5Z9PlfOaQZeFAk39FfkhgdkxGlIyjaribLXfN/BD
vPe+XQMrU8jrnpWnqY8A3Ot6Hrh37xTS28L8rCQvCPd0mDWpob/Q9rFt0vsa
BOHuowAxSvUkuratTdbMh51rrh9HjwlMIoHeLks3BgYxpyyfgtkE2l/V+UHk
OAZRNSXTa2PGkbSzk0JeLgYbHP8TsJw9hoapfa5qixisk1srWqr6ExVZ3W73
0WWAzMjEE5+SURSu0ZhrEMAA6dx32rv3jiDxyLyHhwoZIHklrnHu49+oM7BM
02GQAeJap10LzYaRnxKKkacJgThVa+lS6xAKtzpoEC8rBGIf6VE7HQZRSJ2z
cftmIRC+3Sf/a6AfufLdpTuxa8y64E2uWx/6kD3vwJQRAkHJG2bnJnuQZK2p
8QkuIWBVFFT/MdmNXBnX+wx62eszPTLVvtKBkopP+VjkMWBdO2mNrcBXBCua
qXE+7PW6pB9oZrUg/b49CzE4A6Qmjc9bKDQiuvqnkxQyA8SuTiTUqdajg3cW
3iZXYLBRZMvN+NBqdG/ygdlCKAZrlL06ox++Q6a6TT4HzDDYdOOGo5RXKZqV
q5RSl8GAWbSGi5GTi6YbZyybx+iwNqUxTywmDhUExzyuy6GDMFHjtI2yPvYB
dBAhrscFt4iTI4/SQYl4Hp7t4YgaTOmr78Mftxy5IGBIBwViPbj1Tvz71H/o
wCTWi0v3vMpQsqWDJPE9eLCJxy53V/b9xPfisWkyKvlsP6wn+oHfpVPyNO7Q
YSPRLzzj5SssJo0OykQ/cYGwQJMXhXSQIPqNO4hzWDdU0YFFzAOfFSe732il
gxQxL7w10MI5q5/9PmKe+NRHxrTeP3SQIeaNe7Do165PsftB+AGP1Vyb8HGe
/TzCL/hDplH26SX2/YSfcMObbZ5fVuggS/gNP/+19fRL0r9+xPmu/tmrR8ZA
jvAr3sSgXyln19GEn/E2t5qNlpR//Y5fvjkuL0bFIJbIA54ro71vAwe2mhc8
vuFsdDQntponXMKGcsCTG1vNGx6R6/lgkIZBApFHPD6JLD/Gj63mFffTebvr
CYZBIpFnXD869twmUWw17+x+LWwPZWGrPMAbAv+60ML2y/95gfN//SK7TQGD
FIIn+MXLUrsztrFrgje4Wsr9duPdGKQSPMJ9FV4pKexn1wSv8NampRBtcwzS
CJ7hdboq+647sGuCd7hhR8ejn2cwSCd4iI8Jv+i2YP8npBG8xOXUZTKCwjF4
RPAUp5Yl8+65j63yVke1/8kPpWwMLAge65Rw1+34WYZBE8FrHeuiiinBOmyV
5zoiVVR3/m5slfc6MbWsLXYjbJ3YD3RODFjiJ2YwaCH2Cx3glcyIX8bgv5JW
QD4=
         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.4]], 
        LineBox[CompressedData["
1:eJw9lXs4VFsfx8cYw7jNZsZt1ITcipMKeadoi3QhpRBRlBwl5JSjJCJJRQop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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005], 
         Opacity[0.2]], 
        LineBox[CompressedData["
1:eJw9Vnk4VG0fPmMnY86MfSylSCEqERVHKUQkS4SXkkTLKyGKVF6VSKnsJCGR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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.907755278982122, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"n\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
          HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.907755278982137, 
       2.302585092994046}, {-4.587972165182036, 0}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{0, 0}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 1 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 200 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 500 nm\"", 
       "\"\\!\\(\\*StyleBox[\\\"L\\\",FontSlant->\\\"Italic\\\"]\\) = 10 nm, \
\\!\\(\\*StyleBox[\\\"D\\\",FontSlant->\\\"Italic\\\"]\\) = 1000 nm\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.8]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.4]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09], 
                    Opacity[0.2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.6`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
                   RowBox[{"Opacity", "[", "0.2`", "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.907145962975355*^9, 3.9071460011466484`*^9, 
  3.9071460713552837`*^9, 3.9071461436552773`*^9, 3.913786518623416*^9, 
  3.915270820072725*^9, 3.917498698565129*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"e48b0915-41b4-45db-99cd-d7402ce47104"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\FormFactorsSlopes_Polydisperse_Dimensions.pdf\"\>"], \
"Output",
 CellChangeTimes->{3.907145962975355*^9, 3.9071460011466484`*^9, 
  3.9071460713552837`*^9, 3.9071461436552773`*^9, 3.913786518623416*^9, 
  3.915270820072725*^9, 3.91749869939943*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"dbab2470-a10e-4df3-8d77-5d8e2f2f8d14"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1426.5, 818.25},
WindowMargins->{{0, Automatic}, {Automatic, 0.75}},
Magnification:>0.7 Inherited,
FrontEndVersion->"13.2 for Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7b4b0030-b6c3-40d0-9cc1-2df637420d8e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 291, 4, 68, "Title",ExpressionUUID->"9752d005-1219-465f-8e60-2082113917f8"],
Cell[874, 28, 568, 12, 40, "Text",ExpressionUUID->"49403409-d150-494f-b081-91ce56c28d83"],
Cell[1445, 42, 275, 6, 22, "Item",ExpressionUUID->"c5bb304f-f48f-4254-b437-103257a6e918"],
Cell[1723, 50, 453, 9, 22, "Item",ExpressionUUID->"ae041ac8-eae0-47a3-9bd9-39e8721130f8"],
Cell[CellGroupData[{
Cell[2201, 63, 180, 3, 32, "Subsubsection",ExpressionUUID->"e214e2f0-1723-47e3-b5e6-cc97977345b1"],
Cell[2384, 68, 424, 12, 43, "Input",ExpressionUUID->"6a1e2f36-ed4d-4204-a5ee-f5fb0ba7e773"],
Cell[CellGroupData[{
Cell[2833, 84, 5074, 92, 137, "Input",ExpressionUUID->"bb5b9391-51b5-4754-9301-f8ac33c801e3"],
Cell[7910, 178, 1440, 21, 33, "Output",ExpressionUUID->"3509a962-286c-4324-a276-3a3c68471146"],
Cell[9353, 201, 1290, 19, 33, "Output",ExpressionUUID->"787b56db-b8a8-4b57-a9eb-eb78b2ff5b7f"]
}, Open  ]],
Cell[10658, 223, 2239, 53, 190, "Input",ExpressionUUID->"fc5fd8e9-fab4-4b5c-b2af-d0e7dff8366f"],
Cell[12900, 278, 6779, 175, 256, "Input",ExpressionUUID->"963c927a-6081-41b1-bcc3-11370c5e23da"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19716, 458, 269, 5, 32, "Subsubsection",ExpressionUUID->"bb1efd3e-4cfd-424b-89f2-969547bc7a05"],
Cell[CellGroupData[{
Cell[20010, 467, 31236, 722, 2053, "Input",ExpressionUUID->"f2858960-ee9b-434f-ab6f-b0967ca77d38"],
Cell[51249, 1191, 7183, 112, 99, "Output",ExpressionUUID->"692fa780-1d82-4946-824a-438fc97d74df"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58481, 1309, 217, 4, 37, "Subsection",ExpressionUUID->"9ecbbbc5-8b8f-4847-b220-8094510e4a4e"],
Cell[58701, 1315, 335, 7, 24, "Text",ExpressionUUID->"1226fcdb-2e55-460d-933b-f363aeb6389f"],
Cell[CellGroupData[{
Cell[59061, 1326, 18316, 427, 1185, "Input",ExpressionUUID->"904598d3-3be1-4b29-9812-e84f814faf5c"],
Cell[77380, 1755, 447, 7, 33, "Output",ExpressionUUID->"c7779e7c-ec61-4f95-9b79-7deccb711d30"],
Cell[77830, 1764, 1131, 30, 55, "Output",ExpressionUUID->"a0730413-1dfa-40d0-aaef-32454205bd5c"]
}, Open  ]],
Cell[78976, 1797, 23863, 506, 1036, "Input",ExpressionUUID->"4d2ca9cf-a791-490d-b630-3cfaa5886fc0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102876, 2308, 160, 3, 47, "Section",ExpressionUUID->"105337f8-9f71-463c-ba4f-5445b245946c"],
Cell[103039, 2313, 838, 20, 34, "Input",ExpressionUUID->"e93dc968-6479-4f4d-8783-58aeb15a1214"],
Cell[CellGroupData[{
Cell[103902, 2337, 217, 5, 37, "Subsection",ExpressionUUID->"2c7e915b-284b-4a52-9077-42b65bc60a51"],
Cell[104122, 2344, 492, 9, 40, "Text",ExpressionUUID->"0716ec73-f7da-4d51-adfc-df2d5f6b72d6"],
Cell[104617, 2355, 11739, 315, 247, "Input",ExpressionUUID->"3ff1d24a-bfe7-4aef-b22b-89321bdbef81"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116417, 2677, 153, 3, 68, "Title",ExpressionUUID->"d8104e96-bcdf-4d40-8ea7-520991da3e70"],
Cell[116573, 2682, 15561, 321, 1283, "Input",ExpressionUUID->"ccb04c64-cfac-4dcb-b945-caef09e3f7b0"],
Cell[CellGroupData[{
Cell[132159, 3007, 2035, 47, 100, "Input",ExpressionUUID->"ada8b3f5-d293-4a14-a0eb-400f1f7504a1"],
Cell[134197, 3056, 586, 8, 23, "Output",ExpressionUUID->"ee3eb1a6-e93a-4862-8013-b5e601087a00"],
Cell[134786, 3066, 589, 8, 23, "Output",ExpressionUUID->"7848c754-a775-4980-8d25-12eaafa7de41"],
Cell[135378, 3076, 584, 8, 23, "Output",ExpressionUUID->"645aa8ce-4720-4cda-ab70-b3dbf463b193"],
Cell[135965, 3086, 587, 8, 23, "Output",ExpressionUUID->"24d4d792-1a73-4be6-ab4a-c5cbe8603130"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136589, 3099, 14956, 340, 353, "Input",ExpressionUUID->"ec4e3acb-9558-468a-9a3b-fca0ee179085"],
Cell[151548, 3441, 2204, 35, 20, "Message",ExpressionUUID->"9ea4289b-6a36-4947-8ce6-2472120e6304"],
Cell[153755, 3478, 2205, 35, 20, "Message",ExpressionUUID->"09cb7016-8124-45dc-80d6-28d0566db65c"],
Cell[155963, 3515, 2205, 35, 20, "Message",ExpressionUUID->"248f9d42-ca23-4648-a328-b5f9e8e5b97d"],
Cell[158171, 3552, 2172, 34, 20, "Message",ExpressionUUID->"e8c78226-3696-4e82-9c24-6065114f4866"],
Cell[160346, 3588, 155379, 3594, 173, "Output",ExpressionUUID->"e4950ae0-adec-4bf8-a910-9f4cef0f9670"],
Cell[315728, 7184, 1949, 27, 86, "Output",ExpressionUUID->"be29532c-be6c-4fd7-9af4-1e4ea9e81a54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[317714, 7216, 11406, 271, 319, "Input",ExpressionUUID->"8216ce0b-9b35-4c62-acff-591ffe4f31e6"],
Cell[329123, 7489, 583, 12, 20, "Message",ExpressionUUID->"abcff84f-e6c0-40ff-a830-97d2fd435b87"],
Cell[329709, 7503, 584, 12, 20, "Message",ExpressionUUID->"5fc36753-1a15-4ff0-954c-0d27abf734d0"],
Cell[330296, 7517, 586, 12, 20, "Message",ExpressionUUID->"7107f5d7-0ff6-4f13-abe4-ba286fce1d3a"],
Cell[330885, 7531, 552, 11, 20, "Message",ExpressionUUID->"e88ad506-4ba6-4694-a12d-be5173c48e9d"],
Cell[331440, 7544, 59833, 1274, 193, "Output",ExpressionUUID->"ba2abfaf-76df-4e59-a69a-6c2994eeb0cc"],
Cell[391276, 8820, 951, 14, 33, "Output",ExpressionUUID->"6cbbbc55-ad7c-42d5-ba64-681f60cc181d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[392264, 8839, 12318, 291, 319, "Input",ExpressionUUID->"2c21e791-3c64-4814-add9-6f399d089f54"],
Cell[404585, 9132, 1403, 23, 20, "Message",ExpressionUUID->"c2540ac0-af3c-4d73-ac43-728d4d3674bf"],
Cell[405991, 9157, 1406, 23, 20, "Message",ExpressionUUID->"235334e5-3c69-4672-8e16-f440ec2343b3"],
Cell[407400, 9182, 1405, 23, 20, "Message",ExpressionUUID->"c2bd2a64-293c-427d-b577-d63a02a0166c"],
Cell[408808, 9207, 1370, 22, 20, "Message",ExpressionUUID->"29959e92-3c66-4e6a-a125-2f4d4c356c48"],
Cell[410181, 9231, 46183, 1011, 193, "Output",ExpressionUUID->"b5b7aaa5-5810-4de8-8b69-1af846ef0afc"],
Cell[456367, 10244, 1279, 18, 33, "Output",ExpressionUUID->"9f513095-0ad4-4a29-bb94-dab1e1d70d20"]
}, Open  ]],
Cell[457661, 10265, 105, 1, 21, "Input",ExpressionUUID->"c4e43655-6657-478b-8231-bb4b9cd4e699"],
Cell[CellGroupData[{
Cell[457791, 10270, 5299, 129, 239, "Input",ExpressionUUID->"d2070e18-38e2-41d7-8cd1-b77426b7a375"],
Cell[463093, 10401, 66922, 1601, 189, "Output",ExpressionUUID->"8dd3393a-4cea-4932-b8ca-8b05afec1362"]
}, Open  ]],
Cell[CellGroupData[{
Cell[530052, 12007, 15194, 365, 404, "Input",ExpressionUUID->"0e7a69cc-0930-409f-9504-ded371638160"],
Cell[545249, 12374, 171456, 3984, 183, "Output",ExpressionUUID->"2bc342ef-5970-402f-9685-e2bc272e6324"],
Cell[716708, 16360, 614, 10, 33, "Output",ExpressionUUID->"cf706023-c64a-4d00-a34a-1d9ee6a77986"]
}, Open  ]],
Cell[CellGroupData[{
Cell[717359, 16375, 12137, 286, 338, "Input",ExpressionUUID->"9f706ecb-10fe-4604-b12c-bc20d76b379b"],
Cell[729499, 16663, 158146, 3664, 183, "Output",ExpressionUUID->"d352ddd2-f7a4-458a-9146-f916ccfb56c6"],
Cell[887648, 20329, 640, 11, 86, "Output",ExpressionUUID->"a3ecd714-da69-4334-bc23-babcf05f87b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[888325, 20345, 10903, 268, 319, "Input",ExpressionUUID->"6b2ad393-929f-4b47-9b88-84035511f772"],
Cell[899231, 20615, 58137, 1246, 191, "Output",ExpressionUUID->"e48b0915-41b4-45db-99cd-d7402ce47104"],
Cell[957371, 21863, 493, 8, 33, "Output",ExpressionUUID->"dbab2470-a10e-4df3-8d77-5d8e2f2f8d14"]
}, Open  ]]
}, Open  ]]
}
]
*)

